(ns moncee.database
  (:require [moncee.core :refer :all])
  (:import [com.mongodb.client MongoClients MongoClient MongoIterable MongoCollection MongoDatabase]
           [com.mongodb.client.model Filters Sorts UpdateOptions Indexes]
           [com.mongodb MongoClientSettings])
  (:import [org.bson.codecs.configuration CodecRegistries CodecRegistry])
  (:import [clojure.lang Named])
  (:require [silvur.datetime :refer [datetime* datetime]]))

(defn bound-db
  "Return bound database"
  []
  *db*)

(defn drop!
  "Drop database"
  []
  (when-let [db ^MongoDatabase *db*] (-> db (.drop))))

(defn -list
  "List databases"
  []
  (when-let [cli ^MongoClient *mongo*] (->> cli (.listDatabases) (map bson->))))

(defn list-collection-names
  "List collections"
  []
  (map keyword (.listCollectionNames *db*)))
