(ns moncee.util
  (:require [clojure.walk :as w :refer [postwalk]]
            [camel-snake-kebab.core :as csk]
            [camel-snake-kebab.extras :as cske]
            [clojure.core.memoize :as m])
  (:import [com.mongodb.client.model
            Filters Sorts UpdateOptions Indexes Aggregates Accumulators Projections]
           [org.bson Document]))

(def memoized->camel-string (m/fifo csk/->camelCaseString {} :fifo/threshold 512))

(defmulti bson<- (fn [x]
                   (cond
                     (map? x) :map
                     (seq? x) :seq
                     (vector? x) :seq)))

(defmethod bson<- :map [m]
  (reduce (fn [r [k v]]
            (doto r (.append (name k) (bson<- v))))
          (Document.)
          (postwalk #(if (and (keyword? %) (not= % :_id)) (memoized->camel-string %) %) m)))

(defmethod bson<- :seq [x]
  (vec (map bson<- x)))

(defmethod bson<- :default [x] x)

(defmulti bson-> (fn [x]
                   (cond
                     (instance? Document x) :document
                     (instance? java.util.List x) :seq
                     (sequential? x) :seq)))


(defmethod bson-> :document [doc]
  (loop [m {} d doc]
    (if-not (seq d)
      m
      (recur (let [[k v] (first d)]
               (assoc m (keyword k) (bson-> v))) (rest d)))))

(defmethod bson-> :seq [v]
  (map bson-> v))

(defmethod bson-> :default [x] x)

