(ns moncee.index
  (:require [moncee.core :refer :all]
            [moncee.util :refer [bson-> bson<-]])
  (:import [com.mongodb.client MongoClient MongoClients MongoCollection MongoIterable]
           [com.mongodb.client.model Filters Indexes IndexOptions Sorts UpdateOptions]
           org.bson.conversions.Bson
           com.mongodb.MongoClientSettings
           java.util.ArrayList))

(defn -list [query-source]
  (->> (.listIndexes ^MongoCollection (:source (requester query-source)))
       seq
       (map bson->)))

(defn- compound-index [m]
  (Indexes/compoundIndex
   (reduce (fn [r [k v]]
             (let [k (name k)]
               (.add r (cond
                         (number? v) (if (< v 0)
                                       ^Bson (Indexes/descending [k])
                                       ^Bson (Indexes/ascending  [k]))
                         (= v :hashed) (Indexes/hashed k)
                         (= v :text) (Indexes/text k)))
               r))
           (ArrayList.)
           (dissoc m :unique?))))

(defn create! [query-source & index-maps]
  (let [indexes (set (map :key (-list query-source)))
        ctx (requester query-source)]
    (doseq [m index-maps]
      (when-not (indexes m)
        (let [{:keys [unique? background?]} m
              opts (doto (IndexOptions.)
                     (.unique (true? unique?))
                     (.background (or (nil? background?) (true? background?))))]
          (.createIndex ^MongoCollection (:source ctx)
                        ^Bson (compound-index m)
                        ^IndexOptions opts))))))


(defn drop! [query-source & index-keys]
  (let [ctx (requester query-source)]
    (doseq [m index-keys]
      (.dropIndex ^MongoCollection (:source ctx) ^Bson (bson<- m)))))
