(ns moncee.document
  (:require [moncee.util :refer [bson-> bson<-]]
            [moncee.core :refer :all]
            [moncee.index :as index])
  (:require [taoensso.timbre :as log])
  (:import [clojure.lang Named])
  (:import [moncee Context])
  (:require [silvur.datetime :refer [date<- datetime* datetime today* minute adjust]])
  (:require [clojure.pprint :refer [pprint]]))


(defn query [request-context]
  (.seq ^Context (requester request-context)))

(defn restrict [& params-and-query-source]
  (let [ctx (requester (last params-and-query-source))]
    (->> (partition 2 (butlast params-and-query-source))
         (reduce (fn [result [k v]]
                   (assoc result k (cond
                                     (map? v) (clojure.set/rename-keys v mongo-ops)
                                     :else v)))
                 {})
         (reduce (fn [r [k v]]
                   (update-in  ctx [:operations] conj {:op :filter
                                                       :v {k (if (= k :_id)
                                                               (bson-id v)
                                                               v)}}))
                 ctx))))



(defn project [& kvs-and-query-source]
  (let [query-source (last kvs-and-query-source)
        selects (last (butlast kvs-and-query-source))
        kvs (into {} (if (vector? selects)
                       (map vector selects (repeat true))
                       (map vec (partition 2 (butlast kvs-and-query-source)))))]
    (-> (requester query-source)
        (update :operations conj {:op :project
                                  :v kvs} ))))


(defn order [k direction query-source]
  (-> (requester query-source)
      (update  :operations conj  {:op :sort
                                  :v {k (condp = direction :asc 1 :desc -1)}})))

(defn skip [count query-source]
  (-> (requester query-source)
      (update  :operations conj {:op :skip
                                 :v count})))

(defn limit [count query-source]
  (-> (requester query-source)
      (update  :operations conj {:op :limit
                                 :v count})))

(defn fetch [query-source]
  (-> (requester query-source)
      (update  :operations conj {:op :limit
                                 :v 1})
      (.seq)
      (first)))

(defn insert! [query-source & docs]
  (-> ^Context (requester query-source) (.insert docs)))

(defn delete!
  ([query-source]
   (-> ^Context (requester query-source) (.delete)))
  ([k v & kvs-and-query-source]
   (let [query-source (last kvs-and-query-source)
         kvs (partition 2 (butlast kvs-and-query-source))]
     (delete! (reduce (fn [r [k# v#]]
                        (restrict k# v# r))
                      (restrict k v (requester query-source))
                      kvs)))))

(defn- -update! [upsert? only-one? & ops-and-query-source]
  (let [query-source (last ops-and-query-source)
        ovs (into {} (map vec (partition 2 (butlast ops-and-query-source))))]
    (-> ^Context (requester query-source) (.update upsert? only-one? ovs))))

(defn upsert! [& ops-and-query-source]
  (apply -update! true false ops-and-query-source))

(defn update! [& ops-and-query-source]
  (apply -update! false false ops-and-query-source))

(defn update-1! [& ops-and-query-source]
  (apply -update! false true ops-and-query-source))

(defn map-after [f query-source]
  (update (requester query-source) :operations conj {:op :transduce
                                                     :v {(keyword (gensym)) (map f)}}))

(defn aggregate [& ops-and-query-source]
  (let [query-source (last ops-and-query-source)
        ovs (into {} (map vec (partition 2 (butlast ops-and-query-source))))]

    (update (requester query-source)
            :operations
            conj {:op :group
                  :v ovs})))

;; Todo
;; (ensure-index! :trades [:id :desc ] :unique true)
(defn ensure-index! [])


