(ns moncee.index
  (:require [moncee.core :refer :all]
            [moncee.util :refer [bson<- bson->]])
  (:import [com.mongodb.client MongoClients MongoClient MongoIterable MongoCollection]
           [com.mongodb.client.model Filters Sorts UpdateOptions Indexes IndexOptions]
           [com.mongodb MongoClientSettings])
  (:import [org.bson.codecs.configuration CodecRegistries CodecRegistry])
  (:import [clojure.lang Named])
  (:import [moncee Context])
  (:require [silvur.datetime :refer [datetime* datetime]]))

(defn -list [query-source]
  (->> (requester query-source) :source (.listIndexes) seq (map bson->)))

(defn create! [query-source & index-maps]
  (let [ctx (requester query-source)]
    (doseq [m index-maps]
      (let [{:keys [unique?]} m
            opts (doto (IndexOptions.)
                   (.unique (true? unique?)))]
        (.createIndex (:source ctx)
                      (Indexes/compoundIndex
                       (map (fn [[k v]]
                              (let [k (name k)]
                                (cond
                                  (number? v) (if (< v 0) (Indexes/descending [k]) (Indexes/ascending [k]))
                                  (= v :hashed) (Indexes/hashed k)
                                  (= v :text) (Indexes/text k))))
                            (dissoc m :unique?)))
                      opts)))))

(defn drop! [query-source & index-name-or-maps]
  (let [ctx (requester query-source)]
    (doseq [m index-name-or-maps]
      (.dropIndex (:source ctx) (if (map? m) (bson<- m) m)))))
