(ns moncee.database
  (:require [moncee.core :refer :all]
            [moncee.util :refer [bson->]])
  (:import [com.mongodb.client MongoClients MongoClient MongoIterable MongoCollection]
           [com.mongodb.client.model Filters Sorts UpdateOptions Indexes]
           [com.mongodb MongoClientSettings])
  (:import [org.bson.codecs.configuration CodecRegistries CodecRegistry])
  (:import [clojure.lang Named])
  (:import [moncee Context])
  (:require [silvur.datetime :refer [datetime* datetime]]))

(defn bound-db
  "Return bound database"
  []
  *db*)

(defn drop!
  "Drop database"
  []
  (when-let [db *db*] (-> db (.drop))))

(defn -list
  "List databases"
  []
  (when-let [cli *mongo*] (->> cli (.listDatabases) (map bson->))))
