(ns moncee.util
  (:require [clojure.walk :as w :refer [postwalk]])
  (:import [org.bson Document]))

(defmulti bson<- (fn [x]
                   (cond
                     (map? x) :map
                     (seq? x) :seq
                     (vector? x) :seq)))

(defmethod bson<- :map [m]
  (reduce (fn [r [k v]]
            (doto r (.append k (bson<- v))))
          (Document.)
          (postwalk #(if (keyword? %) (name %) %) m)))

(defmethod bson<- :seq [x]
  (vec (map bson<- x)))

(defmethod bson<- :default [x] x)

(defmulti bson-> (fn [x]
                   (cond
                     (instance? Document x) :document
                     (instance? java.util.List x) :seq
                     (sequential? x) :seq)))


(defmethod bson-> :document [doc]
  (loop [m {} d doc]
    (if-not (seq d)
      m
      (recur (let [[k v] (first d)]
               (assoc m (keyword k) (bson-> v))) (rest d)))))

(defmethod bson-> :seq [v]
  (map bson-> v))

(defmethod bson-> :default [x] x)
