/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.util.Enumeration;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;

public class TestResult {
    protected Vector<TestFailure> fFailures = new Vector();
    protected Vector<TestFailure> fErrors = new Vector();
    protected Vector<TestListener> fListeners = new Vector();
    protected int fRunTests = 0;
    private boolean fStop = false;

    public synchronized void addError(Test test2, Throwable t) {
        this.fErrors.addElement(new TestFailure(test2, t));
        Enumeration e2 = this.cloneListeners().elements();
        while (e2.hasMoreElements()) {
            ((TestListener)e2.nextElement()).addError(test2, t);
        }
    }

    public synchronized void addFailure(Test test2, AssertionFailedError t) {
        this.fFailures.addElement(new TestFailure(test2, t));
        Enumeration e2 = this.cloneListeners().elements();
        while (e2.hasMoreElements()) {
            ((TestListener)e2.nextElement()).addFailure(test2, t);
        }
    }

    public synchronized void addListener(TestListener listener) {
        this.fListeners.addElement(listener);
    }

    public synchronized void removeListener(TestListener listener) {
        this.fListeners.removeElement(listener);
    }

    private synchronized Vector cloneListeners() {
        return (Vector)this.fListeners.clone();
    }

    public void endTest(Test test2) {
        Enumeration e2 = this.cloneListeners().elements();
        while (e2.hasMoreElements()) {
            ((TestListener)e2.nextElement()).endTest(test2);
        }
    }

    public synchronized int errorCount() {
        return this.fErrors.size();
    }

    public synchronized Enumeration errors() {
        return this.fErrors.elements();
    }

    public synchronized int failureCount() {
        return this.fFailures.size();
    }

    public synchronized Enumeration failures() {
        return this.fFailures.elements();
    }

    protected void run(final TestCase test2) {
        this.startTest(test2);
        Protectable p = new Protectable(){

            @Override
            public void protect() throws Throwable {
                test2.runBare();
            }
        };
        this.runProtected(test2, p);
        this.endTest(test2);
    }

    public synchronized int runCount() {
        return this.fRunTests;
    }

    public void runProtected(Test test2, Protectable p) {
        try {
            p.protect();
        }
        catch (AssertionFailedError e2) {
            this.addFailure(test2, e2);
        }
        catch (ThreadDeath e3) {
            throw e3;
        }
        catch (Throwable e4) {
            this.addError(test2, e4);
        }
    }

    public synchronized boolean shouldStop() {
        return this.fStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTest(Test test2) {
        int count2 = test2.countTestCases();
        TestResult testResult = this;
        synchronized (testResult) {
            this.fRunTests += count2;
        }
        Enumeration e2 = this.cloneListeners().elements();
        while (e2.hasMoreElements()) {
            ((TestListener)e2.nextElement()).startTest(test2);
        }
    }

    public synchronized void stop() {
        this.fStop = true;
    }

    public synchronized boolean wasSuccessful() {
        return this.failureCount() == 0 && this.errorCount() == 0;
    }
}

