/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions;

import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class ActiveTestSuite
extends TestSuite {
    private volatile int fActiveTestDeathCount;

    public ActiveTestSuite() {
    }

    public ActiveTestSuite(Class theClass) {
        super(theClass);
    }

    public ActiveTestSuite(String name2) {
        super(name2);
    }

    public ActiveTestSuite(Class theClass, String name2) {
        super(theClass, name2);
    }

    @Override
    public void run(TestResult result) {
        this.fActiveTestDeathCount = 0;
        super.run(result);
        this.waitUntilFinished();
    }

    @Override
    public void runTest(final Test test2, final TestResult result) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    test2.run(result);
                }
                finally {
                    ActiveTestSuite.this.runFinished(test2);
                }
            }
        };
        t.start();
    }

    synchronized void waitUntilFinished() {
        while (this.fActiveTestDeathCount < this.testCount()) {
            try {
                this.wait();
            }
            catch (InterruptedException e2) {
                return;
            }
        }
    }

    public synchronized void runFinished(Test test2) {
        ++this.fActiveTestDeathCount;
        this.notifyAll();
    }
}

