/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util._tests;

import com.android.dx.util.BitIntSet;
import com.android.dx.util.IntIterator;
import com.android.dx.util.ListIntSet;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class _ListIntSet
extends TestCase {
    public void test_basic() {
        ListIntSet set2 = new ListIntSet();
        _ListIntSet.assertEquals(0, set2.elements());
        set2.add(31);
        set2.add(0);
        set2.add(1);
        _ListIntSet.assertTrue(set2.has(0));
        _ListIntSet.assertTrue(set2.has(1));
        _ListIntSet.assertTrue(set2.has(31));
        _ListIntSet.assertEquals(3, set2.elements());
        _ListIntSet.assertFalse(set2.has(2));
        _ListIntSet.assertFalse(set2.has(7));
        _ListIntSet.assertFalse(set2.has(30));
    }

    public void test_iterator() {
        ListIntSet set2 = new ListIntSet();
        set2.add(0);
        set2.add(0);
        set2.add(1);
        set2.add(1);
        set2.add(31);
        set2.add(31);
        IntIterator iter = set2.iterator();
        _ListIntSet.assertTrue(iter.hasNext());
        _ListIntSet.assertEquals(iter.next(), 0);
        _ListIntSet.assertTrue(iter.hasNext());
        _ListIntSet.assertEquals(iter.next(), 1);
        _ListIntSet.assertTrue(iter.hasNext());
        _ListIntSet.assertEquals(iter.next(), 31);
        _ListIntSet.assertFalse(iter.hasNext());
        try {
            iter.next();
            _ListIntSet.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void test_empty() {
        ListIntSet set2 = new ListIntSet();
        IntIterator iter = set2.iterator();
        _ListIntSet.assertFalse(iter.hasNext());
    }

    public void test_remove() {
        ListIntSet set2 = new ListIntSet();
        set2.add(0);
        set2.add(1);
        set2.add(31);
        _ListIntSet.assertTrue(set2.has(0));
        _ListIntSet.assertTrue(set2.has(1));
        _ListIntSet.assertTrue(set2.has(31));
        _ListIntSet.assertFalse(set2.has(2));
        _ListIntSet.assertFalse(set2.has(7));
        _ListIntSet.assertFalse(set2.has(30));
        set2.remove(0);
        _ListIntSet.assertFalse(set2.has(0));
        _ListIntSet.assertTrue(set2.has(1));
        _ListIntSet.assertTrue(set2.has(31));
    }

    public void test_mergeA() {
        int i;
        ListIntSet setA = new ListIntSet();
        int[] valuesA = new int[]{0, 1, 31};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        ListIntSet setB = new ListIntSet();
        int[] valuesB = new int[]{0, 5, 6, 32, 127, 128};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _ListIntSet.assertTrue(setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _ListIntSet.assertTrue(setA.has(valuesB[i]));
        }
    }

    public void test_mergeB() {
        int i;
        ListIntSet setA = new ListIntSet();
        int[] valuesA = new int[]{0, 1, 31, 129, 130};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        ListIntSet setB = new ListIntSet();
        int[] valuesB = new int[]{0, 5, 6, 32, 127, 128};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _ListIntSet.assertTrue(setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _ListIntSet.assertTrue(setA.has(valuesB[i]));
        }
    }

    public void test_mergeWithBitIntSet() {
        int i;
        ListIntSet setA = new ListIntSet();
        int[] valuesA = new int[]{0, 1, 31, 129, 130};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        BitIntSet setB = new BitIntSet(129);
        int[] valuesB = new int[]{0, 5, 6, 32, 127, 128};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _ListIntSet.assertTrue(setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _ListIntSet.assertTrue(setA.has(valuesB[i]));
        }
    }

    public void test_toString() {
        ListIntSet set2 = new ListIntSet();
        _ListIntSet.assertEquals(set2.toString(), "{}");
        set2.add(1);
        _ListIntSet.assertEquals(set2.toString(), "{1}");
        set2.add(2);
        _ListIntSet.assertEquals(set2.toString(), "{1, 2}");
    }
}

