/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.merge;

import com.android.dx.io.ClassDef;
import com.android.dx.io.DexBuffer;
import java.util.Comparator;

final class SortableType {
    public static final Comparator<SortableType> NULLS_LAST_ORDER = new Comparator<SortableType>(){

        @Override
        public int compare(SortableType a, SortableType b) {
            if (a == b) {
                return 0;
            }
            if (b == null) {
                return -1;
            }
            if (a == null) {
                return 1;
            }
            if (a.depth != b.depth) {
                return a.depth - b.depth;
            }
            return a.getTypeIndex() - b.getTypeIndex();
        }
    };
    private final DexBuffer buffer;
    private ClassDef classDef;
    private int depth = -1;

    public SortableType(DexBuffer buffer, ClassDef classDef) {
        this.buffer = buffer;
        this.classDef = classDef;
    }

    public DexBuffer getBuffer() {
        return this.buffer;
    }

    public ClassDef getClassDef() {
        return this.classDef;
    }

    public int getTypeIndex() {
        return this.classDef.getTypeIndex();
    }

    public boolean tryAssignDepth(SortableType[] types) {
        int max2;
        if (this.classDef.getSupertypeIndex() == -1) {
            max2 = 0;
        } else {
            SortableType sortableSupertype = types[this.classDef.getSupertypeIndex()];
            if (sortableSupertype == null) {
                max2 = 1;
            } else {
                if (sortableSupertype.depth == -1) {
                    return false;
                }
                max2 = sortableSupertype.depth;
            }
        }
        for (short interfaceIndex : this.classDef.getInterfaces()) {
            SortableType implemented = types[interfaceIndex];
            if (implemented == null) {
                max2 = Math.max(max2, 1);
                continue;
            }
            if (implemented.depth == -1) {
                return false;
            }
            max2 = Math.max(max2, implemented.depth);
        }
        this.depth = max2 + 1;
        return true;
    }

    public boolean isDepthAssigned() {
        return this.depth != -1;
    }
}

