/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.dex.TableOfContents;
import com.android.dx.io.ClassDef;
import com.android.dx.io.DexBuffer;
import com.android.dx.io.FieldId;
import com.android.dx.io.MethodId;
import com.android.dx.io.ProtoId;
import java.io.File;
import java.io.IOException;

public final class DexIndexPrinter {
    private final DexBuffer dexBuffer;
    private final TableOfContents tableOfContents;

    public DexIndexPrinter(File file2) throws IOException {
        this.dexBuffer = new DexBuffer(file2);
        this.tableOfContents = this.dexBuffer.getTableOfContents();
    }

    private void printMap() {
        for (TableOfContents.Section section : this.tableOfContents.sections) {
            if (section.off == -1) continue;
            System.out.println("section " + Integer.toHexString(section.type) + " off=" + Integer.toHexString(section.off) + " size=" + Integer.toHexString(section.size) + " byteCount=" + Integer.toHexString(section.byteCount));
        }
    }

    private void printStrings() throws IOException {
        int index2 = 0;
        for (String string2 : this.dexBuffer.strings()) {
            System.out.println("string " + index2 + ": " + string2);
            ++index2;
        }
    }

    private void printTypeIds() throws IOException {
        int index2 = 0;
        for (Integer type2 : this.dexBuffer.typeIds()) {
            System.out.println("type " + index2 + ": " + this.dexBuffer.strings().get(type2));
            ++index2;
        }
    }

    private void printProtoIds() throws IOException {
        int index2 = 0;
        for (ProtoId protoId : this.dexBuffer.protoIds()) {
            System.out.println("proto " + index2 + ": " + protoId);
            ++index2;
        }
    }

    private void printFieldIds() throws IOException {
        int index2 = 0;
        for (FieldId fieldId : this.dexBuffer.fieldIds()) {
            System.out.println("field " + index2 + ": " + fieldId);
            ++index2;
        }
    }

    private void printMethodIds() throws IOException {
        int index2 = 0;
        for (MethodId methodId : this.dexBuffer.methodIds()) {
            System.out.println("methodId " + index2 + ": " + methodId);
            ++index2;
        }
    }

    private void printTypeLists() throws IOException {
        if (this.tableOfContents.typeLists.off == -1) {
            System.out.println("No type lists");
            return;
        }
        DexBuffer.Section in = this.dexBuffer.open(this.tableOfContents.typeLists.off);
        for (int i = 0; i < this.tableOfContents.typeLists.size; ++i) {
            int size = in.readInt();
            System.out.print("Type list i=" + i + ", size=" + size + ", elements=");
            for (int t = 0; t < size; ++t) {
                System.out.print(" " + this.dexBuffer.typeNames().get(in.readShort()));
            }
            if (size % 2 == 1) {
                in.readShort();
            }
            System.out.println();
        }
    }

    private void printClassDefs() {
        int index2 = 0;
        for (ClassDef classDef : this.dexBuffer.classDefs()) {
            System.out.println("class def " + index2 + ": " + classDef);
            ++index2;
        }
    }

    public static void main(String[] args) throws IOException {
        DexIndexPrinter indexPrinter = new DexIndexPrinter(new File(args[0]));
        indexPrinter.printMap();
        indexPrinter.printStrings();
        indexPrinter.printTypeIds();
        indexPrinter.printProtoIds();
        indexPrinter.printFieldIds();
        indexPrinter.printMethodIds();
        indexPrinter.printTypeLists();
        indexPrinter.printClassDefs();
    }
}

