/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.dex.TableOfContents;
import com.android.dx.io.Annotation;
import com.android.dx.io.ClassData;
import com.android.dx.io.ClassDef;
import com.android.dx.io.Code;
import com.android.dx.io.EncodedValue;
import com.android.dx.io.EncodedValueReader;
import com.android.dx.io.FieldId;
import com.android.dx.io.MethodId;
import com.android.dx.io.ProtoId;
import com.android.dx.merge.TypeList;
import com.android.dx.util.ByteInput;
import com.android.dx.util.ByteOutput;
import com.android.dx.util.DexException;
import com.android.dx.util.FileUtils;
import com.android.dx.util.Leb128Utils;
import com.android.dx.util.Mutf8;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class DexBuffer {
    private byte[] data;
    private final TableOfContents tableOfContents = new TableOfContents();
    private int length = 0;
    private final List<String> strings = new AbstractList<String>(){

        @Override
        public String get(int index2) {
            DexBuffer.checkBounds(index2, ((DexBuffer)DexBuffer.this).tableOfContents.stringIds.size);
            return DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.stringIds.off + index2 * 4).readString();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.stringIds.size;
        }
    };
    private final List<Integer> typeIds = new AbstractList<Integer>(){

        @Override
        public Integer get(int index2) {
            DexBuffer.checkBounds(index2, ((DexBuffer)DexBuffer.this).tableOfContents.typeIds.size);
            return DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.typeIds.off + index2 * 4).readInt();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.typeIds.size;
        }
    };
    private final List<String> typeNames = new AbstractList<String>(){

        @Override
        public String get(int index2) {
            DexBuffer.checkBounds(index2, ((DexBuffer)DexBuffer.this).tableOfContents.typeIds.size);
            return (String)DexBuffer.this.strings.get((Integer)DexBuffer.this.typeIds.get(index2));
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.typeIds.size;
        }
    };
    private final List<ProtoId> protoIds = new AbstractList<ProtoId>(){

        @Override
        public ProtoId get(int index2) {
            DexBuffer.checkBounds(index2, ((DexBuffer)DexBuffer.this).tableOfContents.protoIds.size);
            return DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.protoIds.off + 12 * index2).readProtoId();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.protoIds.size;
        }
    };
    private final List<FieldId> fieldIds = new AbstractList<FieldId>(){

        @Override
        public FieldId get(int index2) {
            DexBuffer.checkBounds(index2, ((DexBuffer)DexBuffer.this).tableOfContents.fieldIds.size);
            return DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.fieldIds.off + 8 * index2).readFieldId();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.fieldIds.size;
        }
    };
    private final List<MethodId> methodIds = new AbstractList<MethodId>(){

        @Override
        public MethodId get(int index2) {
            DexBuffer.checkBounds(index2, ((DexBuffer)DexBuffer.this).tableOfContents.methodIds.size);
            return DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.methodIds.off + 8 * index2).readMethodId();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.methodIds.size;
        }
    };

    public DexBuffer() {
        this.data = new byte[0];
    }

    public DexBuffer(byte[] data2) throws IOException {
        this.data = data2;
        this.length = data2.length;
        this.tableOfContents.readFrom(this);
    }

    public DexBuffer(InputStream in) throws IOException {
        this.loadFrom(in);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DexBuffer(File file2) throws IOException {
        if (FileUtils.hasArchiveSuffix(file2.getName())) {
            ZipFile zipFile = new ZipFile(file2);
            ZipEntry entry = zipFile.getEntry("classes.dex");
            if (entry == null) throw new DexException("Expected classes.dex in " + file2);
            this.loadFrom(zipFile.getInputStream(entry));
            zipFile.close();
            return;
        } else {
            if (!file2.getName().endsWith(".dex")) throw new DexException("unknown output extension: " + file2);
            this.loadFrom(new FileInputStream(file2));
        }
    }

    private void loadFrom(InputStream in) throws IOException {
        int count2;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((count2 = in.read(buffer)) != -1) {
            bytesOut.write(buffer, 0, count2);
        }
        in.close();
        this.data = bytesOut.toByteArray();
        this.length = this.data.length;
        this.tableOfContents.readFrom(this);
    }

    private static void checkBounds(int index2, int length) {
        if (index2 < 0 || index2 >= length) {
            throw new IndexOutOfBoundsException("index:" + index2 + ", length=" + length);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.data);
    }

    public void writeTo(File dexOut) throws IOException {
        FileOutputStream out = new FileOutputStream(dexOut);
        this.writeTo(out);
        ((OutputStream)out).close();
    }

    public TableOfContents getTableOfContents() {
        return this.tableOfContents;
    }

    public Section open(int position) {
        if (position < 0 || position > this.length) {
            throw new IllegalArgumentException("position=" + position + " length=" + this.length);
        }
        return new Section(position);
    }

    public Section appendSection(int maxByteCount, String name2) {
        int limit = DexBuffer.fourByteAlign(this.length + maxByteCount);
        Section result = new Section(name2, this.length, limit);
        this.length = limit;
        return result;
    }

    public void noMoreSections() {
        this.data = new byte[this.length];
    }

    public int getLength() {
        return this.length;
    }

    private static int fourByteAlign(int position) {
        return position + 3 & 0xFFFFFFFC;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public List<String> strings() {
        return this.strings;
    }

    public List<Integer> typeIds() {
        return this.typeIds;
    }

    public List<String> typeNames() {
        return this.typeNames;
    }

    public List<ProtoId> protoIds() {
        return this.protoIds;
    }

    public List<FieldId> fieldIds() {
        return this.fieldIds;
    }

    public List<MethodId> methodIds() {
        return this.methodIds;
    }

    public Iterable<ClassDef> classDefs() {
        return new Iterable<ClassDef>(){

            @Override
            public Iterator<ClassDef> iterator() {
                if (!((DexBuffer)DexBuffer.this).tableOfContents.classDefs.exists()) {
                    return Collections.emptySet().iterator();
                }
                return new Iterator<ClassDef>(){
                    private Section in;
                    private int count;
                    {
                        this.in = DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.classDefs.off);
                        this.count = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.count < ((DexBuffer)DexBuffer.this).tableOfContents.classDefs.size;
                    }

                    @Override
                    public ClassDef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.count;
                        return this.in.readClassDef();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public TypeList readTypeList(int offset) {
        if (offset == 0) {
            return TypeList.EMPTY;
        }
        return this.open(offset).readTypeList();
    }

    public ClassData readClassData(ClassDef classDef) {
        int offset = classDef.getClassDataOffset();
        if (offset == 0) {
            throw new IllegalArgumentException("offset == 0");
        }
        return this.open(offset).readClassData();
    }

    public Code readCode(ClassData.Method method) {
        int offset = method.getCodeOffset();
        if (offset == 0) {
            throw new IllegalArgumentException("offset == 0");
        }
        return this.open(offset).readCode();
    }

    public final class Section
    implements ByteInput,
    ByteOutput {
        private final String name;
        private int position;
        private final int limit;

        private Section(String name2, int position, int limit) {
            this.name = name2;
            this.position = position;
            this.limit = limit;
        }

        private Section(int position) {
            this("section", position, this$0.data.length);
        }

        public int getPosition() {
            return this.position;
        }

        public int readInt() {
            int result = DexBuffer.this.data[this.position] & 0xFF | (DexBuffer.this.data[this.position + 1] & 0xFF) << 8 | (DexBuffer.this.data[this.position + 2] & 0xFF) << 16 | (DexBuffer.this.data[this.position + 3] & 0xFF) << 24;
            this.position += 4;
            return result;
        }

        public short readShort() {
            int result = DexBuffer.this.data[this.position] & 0xFF | (DexBuffer.this.data[this.position + 1] & 0xFF) << 8;
            this.position += 2;
            return (short)result;
        }

        public int readUnsignedShort() {
            return this.readShort() & 0xFFFF;
        }

        @Override
        public byte readByte() {
            return (byte)(DexBuffer.this.data[this.position++] & 0xFF);
        }

        public byte[] readByteArray(int length) {
            byte[] result = Arrays.copyOfRange(DexBuffer.this.data, this.position, this.position + length);
            this.position += length;
            return result;
        }

        public short[] readShortArray(int length) {
            short[] result = new short[length];
            for (int i = 0; i < length; ++i) {
                result[i] = this.readShort();
            }
            return result;
        }

        public int readUleb128() {
            return Leb128Utils.readUnsignedLeb128(this);
        }

        public int readSleb128() {
            return Leb128Utils.readSignedLeb128(this);
        }

        public TypeList readTypeList() {
            int size = this.readInt();
            short[] types = new short[size];
            for (int i = 0; i < size; ++i) {
                types[i] = this.readShort();
            }
            this.alignToFourBytes();
            return new TypeList(DexBuffer.this, types);
        }

        public String readString() {
            int offset = this.readInt();
            int savedPosition = this.position;
            this.position = offset;
            try {
                int expectedLength = this.readUleb128();
                String result = Mutf8.decode(this, new char[expectedLength]);
                if (result.length() != expectedLength) {
                    throw new DexException("Declared length " + expectedLength + " doesn't match decoded length of " + result.length());
                }
                String string2 = result;
                return string2;
            }
            catch (UTFDataFormatException e2) {
                throw new DexException(e2);
            }
            finally {
                this.position = savedPosition;
            }
        }

        public FieldId readFieldId() {
            int declaringClassIndex = this.readUnsignedShort();
            int typeIndex = this.readUnsignedShort();
            int nameIndex = this.readInt();
            return new FieldId(DexBuffer.this, declaringClassIndex, typeIndex, nameIndex);
        }

        public MethodId readMethodId() {
            int declaringClassIndex = this.readUnsignedShort();
            int protoIndex = this.readUnsignedShort();
            int nameIndex = this.readInt();
            return new MethodId(DexBuffer.this, declaringClassIndex, protoIndex, nameIndex);
        }

        public ProtoId readProtoId() {
            int shortyIndex = this.readInt();
            int returnTypeIndex = this.readInt();
            int parametersOffset = this.readInt();
            return new ProtoId(DexBuffer.this, shortyIndex, returnTypeIndex, parametersOffset);
        }

        public ClassDef readClassDef() {
            int offset = this.getPosition();
            int type2 = this.readInt();
            int accessFlags = this.readInt();
            int supertype = this.readInt();
            int interfacesOffset = this.readInt();
            int sourceFileIndex = this.readInt();
            int annotationsOffset = this.readInt();
            int classDataOffset = this.readInt();
            int staticValuesOffset = this.readInt();
            return new ClassDef(DexBuffer.this, offset, type2, accessFlags, supertype, interfacesOffset, sourceFileIndex, annotationsOffset, classDataOffset, staticValuesOffset);
        }

        private Code readCode() {
            int registersSize = this.readUnsignedShort();
            int insSize = this.readUnsignedShort();
            int outsSize = this.readUnsignedShort();
            int triesSize = this.readUnsignedShort();
            int debugInfoOffset = this.readInt();
            int instructionsSize = this.readInt();
            short[] instructions = this.readShortArray(instructionsSize);
            Code.Try[] tries = new Code.Try[triesSize];
            Code.CatchHandler[] catchHandlers = new Code.CatchHandler[]{};
            if (triesSize > 0) {
                if (instructions.length % 2 == 1) {
                    this.readShort();
                }
                for (int i = 0; i < triesSize; ++i) {
                    int startAddress = this.readInt();
                    int instructionCount = this.readUnsignedShort();
                    int handlerOffset = this.readUnsignedShort();
                    tries[i] = new Code.Try(startAddress, instructionCount, handlerOffset);
                }
                int catchHandlersSize = this.readUleb128();
                catchHandlers = new Code.CatchHandler[catchHandlersSize];
                for (int i = 0; i < catchHandlersSize; ++i) {
                    catchHandlers[i] = this.readCatchHandler();
                }
            }
            return new Code(registersSize, insSize, outsSize, debugInfoOffset, instructions, tries, catchHandlers);
        }

        private Code.CatchHandler readCatchHandler() {
            int size = this.readSleb128();
            int handlersCount = Math.abs(size);
            int[] typeIndexes = new int[handlersCount];
            int[] addresses = new int[handlersCount];
            for (int i = 0; i < handlersCount; ++i) {
                typeIndexes[i] = this.readUleb128();
                addresses[i] = this.readUleb128();
            }
            int catchAllAddress = size <= 0 ? this.readUleb128() : -1;
            return new Code.CatchHandler(typeIndexes, addresses, catchAllAddress);
        }

        private ClassData readClassData() {
            int staticFieldsSize = this.readUleb128();
            int instanceFieldsSize = this.readUleb128();
            int directMethodsSize = this.readUleb128();
            int virtualMethodsSize = this.readUleb128();
            ClassData.Field[] staticFields = this.readFields(staticFieldsSize);
            ClassData.Field[] instanceFields = this.readFields(instanceFieldsSize);
            ClassData.Method[] directMethods = this.readMethods(directMethodsSize);
            ClassData.Method[] virtualMethods = this.readMethods(virtualMethodsSize);
            return new ClassData(staticFields, instanceFields, directMethods, virtualMethods);
        }

        private ClassData.Field[] readFields(int count2) {
            ClassData.Field[] result = new ClassData.Field[count2];
            int fieldIndex = 0;
            for (int i = 0; i < count2; ++i) {
                int accessFlags = this.readUleb128();
                result[i] = new ClassData.Field(fieldIndex += this.readUleb128(), accessFlags);
            }
            return result;
        }

        private ClassData.Method[] readMethods(int count2) {
            ClassData.Method[] result = new ClassData.Method[count2];
            int methodIndex = 0;
            for (int i = 0; i < count2; ++i) {
                int accessFlags = this.readUleb128();
                int codeOff = this.readUleb128();
                result[i] = new ClassData.Method(methodIndex += this.readUleb128(), accessFlags, codeOff);
            }
            return result;
        }

        public Annotation readAnnotation() {
            byte visibility = this.readByte();
            int typeIndex = this.readUleb128();
            int size = this.readUleb128();
            int[] names = new int[size];
            EncodedValue[] values = new EncodedValue[size];
            for (int i = 0; i < size; ++i) {
                names[i] = this.readUleb128();
                values[i] = this.readEncodedValue();
            }
            return new Annotation(DexBuffer.this, visibility, typeIndex, names, values);
        }

        public EncodedValue readEncodedValue() {
            int start = this.position;
            new EncodedValueReader(this).readValue();
            int end = this.position;
            return new EncodedValue(Arrays.copyOfRange(DexBuffer.this.data, start, end));
        }

        public EncodedValue readEncodedArray() {
            int start = this.position;
            new EncodedValueReader(this).readArray();
            int end = this.position;
            return new EncodedValue(Arrays.copyOfRange(DexBuffer.this.data, start, end));
        }

        private void ensureCapacity(int size) {
            if (this.position + size > this.limit) {
                throw new DexException("Section limit " + this.limit + " exceeded by " + this.name);
            }
        }

        public void alignToFourBytes() {
            int unalignedCount = this.position;
            this.position = DexBuffer.fourByteAlign(this.position);
            for (int i = unalignedCount; i < this.position; ++i) {
                ((DexBuffer)DexBuffer.this).data[i] = 0;
            }
        }

        public void assertFourByteAligned() {
            if ((this.position & 3) != 0) {
                throw new IllegalStateException("Not four byte aligned!");
            }
        }

        public void write(byte[] bytes2) {
            this.ensureCapacity(bytes2.length);
            System.arraycopy(bytes2, 0, DexBuffer.this.data, this.position, bytes2.length);
            this.position += bytes2.length;
        }

        @Override
        public void writeByte(int b) {
            this.ensureCapacity(1);
            ((DexBuffer)DexBuffer.this).data[this.position++] = (byte)b;
        }

        public void writeShort(short i) {
            this.ensureCapacity(2);
            ((DexBuffer)DexBuffer.this).data[this.position] = (byte)i;
            ((DexBuffer)DexBuffer.this).data[this.position + 1] = (byte)(i >>> 8);
            this.position += 2;
        }

        public void writeUnsignedShort(int i) {
            short s = (short)i;
            if (i != (s & 0xFFFF)) {
                throw new IllegalArgumentException("Expected an unsigned short: " + i);
            }
            this.writeShort(s);
        }

        public void write(short[] shorts2) {
            for (short s : shorts2) {
                this.writeShort(s);
            }
        }

        public void writeInt(int i) {
            this.ensureCapacity(4);
            ((DexBuffer)DexBuffer.this).data[this.position] = (byte)i;
            ((DexBuffer)DexBuffer.this).data[this.position + 1] = (byte)(i >>> 8);
            ((DexBuffer)DexBuffer.this).data[this.position + 2] = (byte)(i >>> 16);
            ((DexBuffer)DexBuffer.this).data[this.position + 3] = (byte)(i >>> 24);
            this.position += 4;
        }

        public void writeUleb128(int i) {
            try {
                Leb128Utils.writeUnsignedLeb128(this, i);
                this.ensureCapacity(0);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new DexException("Section limit " + this.limit + " exceeded by " + this.name);
            }
        }

        public void writeSleb128(int i) {
            try {
                Leb128Utils.writeSignedLeb128(this, i);
                this.ensureCapacity(0);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new DexException("Section limit " + this.limit + " exceeded by " + this.name);
            }
        }

        public void writeStringData(String value) {
            try {
                int length = value.length();
                this.writeUleb128(length);
                this.write(Mutf8.encode(value));
                this.writeByte(0);
            }
            catch (UTFDataFormatException e2) {
                throw new AssertionError();
            }
        }

        public void writeTypeList(TypeList typeList) {
            short[] types = typeList.getTypes();
            this.writeInt(types.length);
            for (short type2 : types) {
                this.writeShort(type2);
            }
            this.alignToFourBytes();
        }

        public int remaining() {
            return this.limit - this.position;
        }
    }
}

