/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.gen;

import com.android.dx.dex.DexOptions;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.RopTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedField;
import com.android.dx.dex.file.EncodedMember;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.gen.Code;
import com.android.dx.gen.Constants;
import com.android.dx.gen.FieldId;
import com.android.dx.gen.MethodId;
import com.android.dx.gen.Type;
import com.android.dx.gen.TypeList;
import com.android.dx.rop.code.LocalVariableInfo;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.StdTypeList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public final class DexGenerator {
    private final Map<Type<?>, TypeDeclaration> types = new LinkedHashMap();

    private TypeDeclaration getTypeDeclaration(Type<?> type2) {
        TypeDeclaration result = this.types.get(type2);
        if (result == null) {
            result = new TypeDeclaration(type2);
            this.types.put(type2, result);
        }
        return result;
    }

    public void declare(Type<?> type2, String sourceFile, int flags, Type<?> supertype, Type<?> ... interfaces) {
        TypeDeclaration declaration = this.getTypeDeclaration(type2);
        if (declaration.declared) {
            throw new IllegalStateException("already declared: " + type2);
        }
        declaration.declared = true;
        declaration.flags = flags;
        declaration.supertype = supertype;
        declaration.sourceFile = sourceFile;
        declaration.interfaces = new TypeList(interfaces);
    }

    public Code declare(MethodId<?, ?> method, int flags) {
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(method.declaringType);
        if (typeDeclaration.methods.containsKey(method)) {
            throw new IllegalStateException("already declared: " + method);
        }
        MethodDeclaration methodDeclaration = new MethodDeclaration(method, flags);
        typeDeclaration.methods.put(method, methodDeclaration);
        return methodDeclaration.code;
    }

    public void declare(FieldId<?, ?> fieldId, int flags, Object staticValue) {
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(fieldId.declaringType);
        if (typeDeclaration.fields.containsKey(fieldId)) {
            throw new IllegalStateException("already declared: " + fieldId);
        }
        FieldDeclaration fieldDeclaration = new FieldDeclaration(fieldId, flags, staticValue);
        typeDeclaration.fields.put(fieldId, fieldDeclaration);
    }

    public byte[] generate() {
        DexFile outputDex = new DexFile(new DexOptions());
        for (TypeDeclaration typeDeclaration : this.types.values()) {
            outputDex.add(typeDeclaration.toClassDefItem());
        }
        try {
            return outputDex.toDex(null, false);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public ClassLoader load(ClassLoader parent) throws IOException {
        byte[] dex = this.generate();
        File result = File.createTempFile("Generated", ".jar");
        result.deleteOnExit();
        JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(result));
        jarOut.putNextEntry(new JarEntry("classes.dex"));
        jarOut.write(dex);
        jarOut.closeEntry();
        jarOut.close();
        try {
            Class<?> pathClassLoader = Class.forName("dalvik.system.PathClassLoader");
            return (ClassLoader)pathClassLoader.getConstructor(String.class, ClassLoader.class).newInstance(result.getPath(), parent);
        }
        catch (ClassNotFoundException e2) {
            throw new UnsupportedOperationException("load() requires a Dalvik VM", e2);
        }
        catch (InvocationTargetException e3) {
            throw new RuntimeException(e3.getCause());
        }
        catch (InstantiationException e4) {
            throw new AssertionError();
        }
        catch (NoSuchMethodException e5) {
            throw new AssertionError();
        }
        catch (IllegalAccessException e6) {
            throw new AssertionError();
        }
    }

    static class MethodDeclaration {
        final MethodId<?, ?> method;
        private final int flags;
        private final Code code;

        public MethodDeclaration(MethodId<?, ?> method, int flags) {
            this.method = method;
            this.flags = flags;
            this.code = new Code(this);
        }

        boolean isStatic() {
            return (this.flags & 8) != 0;
        }

        boolean isDirect() {
            return (this.flags & 0x1000A) != 0;
        }

        EncodedMethod toEncodedMethod(DexOptions dexOptions) {
            RopMethod ropMethod = new RopMethod(this.code.toBasicBlocks(), 0);
            LocalVariableInfo locals = null;
            DalvCode dalvCode = RopTranslator.translate(ropMethod, 1, locals, this.code.paramSize(), dexOptions);
            return new EncodedMethod(this.method.constant, this.flags, dalvCode, StdTypeList.EMPTY);
        }
    }

    static class FieldDeclaration {
        final FieldId<?, ?> fieldId;
        private final int accessFlags;
        private final Object staticValue;

        FieldDeclaration(FieldId<?, ?> fieldId, int accessFlags, Object staticValue) {
            if ((accessFlags & 8) == 0 && staticValue != null) {
                throw new IllegalArgumentException("instance fields may not have a value");
            }
            this.fieldId = fieldId;
            this.accessFlags = accessFlags;
            this.staticValue = staticValue;
        }

        EncodedField toEncodedField() {
            return new EncodedField(this.fieldId.constant, this.accessFlags);
        }

        public boolean isStatic() {
            return (this.accessFlags & 8) != 0;
        }
    }

    private static class TypeDeclaration {
        private final Type<?> type;
        private boolean declared;
        private int flags;
        private Type<?> supertype;
        private String sourceFile;
        private TypeList interfaces;
        private final Map<FieldId, FieldDeclaration> fields = new LinkedHashMap<FieldId, FieldDeclaration>();
        private final Map<MethodId, MethodDeclaration> methods = new LinkedHashMap<MethodId, MethodDeclaration>();

        TypeDeclaration(Type<?> type2) {
            this.type = type2;
        }

        ClassDefItem toClassDefItem() {
            EncodedMember encoded;
            if (!this.declared) {
                throw new IllegalStateException("Undeclared type " + this.type + " declares members: " + this.fields.keySet() + " " + this.methods.keySet());
            }
            DexOptions dexOptions = new DexOptions();
            dexOptions.targetApiLevel = 13;
            CstType thisType = this.type.constant;
            ClassDefItem out = new ClassDefItem(thisType, this.flags, this.supertype.constant, this.interfaces.ropTypes, new CstString(this.sourceFile));
            for (MethodDeclaration method : this.methods.values()) {
                encoded = method.toEncodedMethod(dexOptions);
                if (method.isDirect()) {
                    out.addDirectMethod((EncodedMethod)encoded);
                    continue;
                }
                out.addVirtualMethod((EncodedMethod)encoded);
            }
            for (FieldDeclaration field : this.fields.values()) {
                encoded = field.toEncodedField();
                if (field.isStatic()) {
                    out.addStaticField((EncodedField)encoded, Constants.getConstant(field.staticValue));
                    continue;
                }
                out.addInstanceField((EncodedField)encoded);
            }
            return out;
        }
    }
}

