/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code.form;

import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.InsnFormat;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstLiteralBits;
import com.android.dx.util.AnnotatedOutput;
import java.util.BitSet;

public final class Form32s
extends InsnFormat {
    public static final InsnFormat THE_ONE = new Form32s();

    private Form32s() {
    }

    @Override
    public String insnArgString(DalvInsn insn) {
        RegisterSpecList regs = insn.getRegisters();
        CstLiteralBits value = (CstLiteralBits)((CstInsn)insn).getConstant();
        return regs.get(0).regString() + ", " + regs.get(1).regString() + ", " + Form32s.literalBitsString(value);
    }

    @Override
    public String insnCommentString(DalvInsn insn, boolean noteIndices) {
        CstLiteralBits value = (CstLiteralBits)((CstInsn)insn).getConstant();
        return Form32s.literalBitsComment(value, 16);
    }

    @Override
    public int codeSize() {
        return 3;
    }

    @Override
    public boolean isCompatible(DalvInsn insn) {
        if (!ALLOW_EXTENDED_OPCODES) {
            return false;
        }
        RegisterSpecList regs = insn.getRegisters();
        if (!(insn instanceof CstInsn && regs.size() == 2 && Form32s.unsignedFitsInByte(regs.get(0).getReg()) && Form32s.unsignedFitsInByte(regs.get(1).getReg()))) {
            return false;
        }
        CstInsn ci = (CstInsn)insn;
        Constant cst = ci.getConstant();
        if (!(cst instanceof CstLiteralBits)) {
            return false;
        }
        CstLiteralBits cb = (CstLiteralBits)cst;
        return cb.fitsInInt() && Form32s.signedFitsInShort(cb.getIntBits());
    }

    @Override
    public BitSet compatibleRegs(DalvInsn insn) {
        RegisterSpecList regs = insn.getRegisters();
        BitSet bits = new BitSet(2);
        bits.set(0, Form32s.unsignedFitsInByte(regs.get(0).getReg()));
        bits.set(1, Form32s.unsignedFitsInByte(regs.get(1).getReg()));
        return bits;
    }

    @Override
    public void writeTo(AnnotatedOutput out, DalvInsn insn) {
        RegisterSpecList regs = insn.getRegisters();
        int value = ((CstLiteralBits)((CstInsn)insn).getConstant()).getIntBits();
        Form32s.write(out, Form32s.opcodeUnit(insn), Form32s.codeUnit(regs.get(0).getReg(), regs.get(1).getReg()), (short)value);
    }
}

