/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.grep;

import com.android.dx.io.ClassData;
import com.android.dx.io.ClassDef;
import com.android.dx.io.CodeReader;
import com.android.dx.io.DexBuffer;
import com.android.dx.io.EncodedValueReader;
import com.android.dx.io.MethodId;
import com.android.dx.io.instructions.DecodedInstruction;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

public final class Grep {
    private final DexBuffer dex;
    private final CodeReader codeReader = new CodeReader();
    private final Set<Integer> stringIds;
    private final PrintWriter out;
    private int count = 0;
    private ClassDef currentClass;
    private ClassData.Method currentMethod;

    public Grep(DexBuffer dex, Pattern pattern, PrintWriter out) {
        this.dex = dex;
        this.out = out;
        this.stringIds = this.getStringIds(dex, pattern);
        this.codeReader.setStringVisitor(new CodeReader.Visitor(){

            @Override
            public void visit(DecodedInstruction[] all, DecodedInstruction one) {
                Grep.this.encounterString(one.getIndex());
            }
        });
    }

    private EncodedValueReader newEncodedValueReader(DexBuffer.Section section) {
        return new EncodedValueReader(section){

            @Override
            protected void visitString(int type2, int index2) {
                Grep.this.encounterString(index2);
            }
        };
    }

    private void encounterString(int index2) {
        if (this.stringIds.contains(index2)) {
            this.out.println(this.location() + " " + this.dex.strings().get(index2));
            ++this.count;
        }
    }

    private String location() {
        String className = this.dex.typeNames().get(this.currentClass.getTypeIndex());
        if (this.currentMethod != null) {
            MethodId methodId = this.dex.methodIds().get(this.currentMethod.getMethodIndex());
            return className + "." + this.dex.strings().get(methodId.getNameIndex());
        }
        return className;
    }

    public int grep() {
        Iterator<ClassDef> iterator = this.dex.classDefs().iterator();
        while (iterator.hasNext()) {
            ClassDef classDef;
            this.currentClass = classDef = iterator.next();
            this.currentMethod = null;
            if (classDef.getClassDataOffset() == 0) continue;
            ClassData classData = this.dex.readClassData(classDef);
            int staticValuesOffset = classDef.getStaticValuesOffset();
            if (staticValuesOffset != 0) {
                this.newEncodedValueReader(this.dex.open(staticValuesOffset)).readArray();
            }
            ClassData.Method[] methodArray = classData.allMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                ClassData.Method method;
                this.currentMethod = method = methodArray[i];
                if (method.getCodeOffset() == 0) continue;
                this.codeReader.visitAll(this.dex.readCode(method).getInstructions());
            }
        }
        this.currentClass = null;
        this.currentMethod = null;
        return this.count;
    }

    private Set<Integer> getStringIds(DexBuffer dex, Pattern pattern) {
        HashSet<Integer> stringIds = new HashSet<Integer>();
        int stringIndex = 0;
        for (String s : dex.strings()) {
            if (pattern.matcher(s).find()) {
                stringIds.add(stringIndex);
            }
            ++stringIndex;
        }
        return stringIds;
    }
}

