(ns nim.brochure
  (:require-macros
    [tailrecursion.javelin.macros   :refer [cell]])
  (:require
    [tailrecursion.javelin          :as j]
    [clojure.string                 :as string]
    [tailrecursion.hoplon.util      :as u]
    [tailrecursion.hoplon.reactive  :as r]
    [hlisp.wigwam                   :as w]))

(def brand          (atom -1)) 
(def loading        w/loading) 
(def page           (cell '{})) 
(def state          (cell nil)) 
(def error          (cell nil)) 
(def notice         (cell nil)) 
(def warning        (cell nil)) 

(let [async         #(fn [& args] (w/async (apply %2 args) %1 error))
      m-create-lead (async state js/NiM.API.Brochure.createLead)]

  (defn create-lead!
    [promo first last height weight gender birthdate email phone]
    (m-create-lead @brand promo first last height weight gender birthdate email phone))

  (defn init
    [b]
    (reset! brand b)
    (reset! w/keywordize true)))
