(ns nim.order
  (:require-macros
    [tailrecursion.javelin.macros   :refer [cell]])
  (:require
    [clojure.string                 :as string]
    [tailrecursion.hoplon.util      :as u]
    [tailrecursion.hoplon.reactive  :as r]
    [hlisp.wigwam                   :as w]
    [tailrecursion.javelin          :as j]))

(def brand            (atom -1)) 
(def loading          w/loading) 
(def page             (cell '{})) 
(def state            (cell nil)) 
(def error            (cell nil)) 
(def promo            (cell '(:promo w/search)))
(def use-existing-cc  (cell false))

(let [async       (fn [c f] #(w/async (apply f %&) c error))

      m-info      js/NiM.API.Order.clientInfo
      m-login     (async state js/NiM.API.Order.loginOrder) 
      m-replace   (async state js/NiM.API.Order.replaceOrder) 
      m-contact   (async state js/NiM.API.Order.contactOrder) 
      m-ship      (async state js/NiM.API.Order.shippingAddress) 
      m-bill      (async state js/NiM.API.Order.billingInfo)

      first-name  (cell (:firstName state))
      last-name   (cell (:lastName state))
      reorder     (cell (let [{cid              :clientID
                              {oid :order_id}   :order
                              {ord-promo :code} :promotion} state
                              req-promo         (string/upper-case (str promo)) 
                              ord-promo         (string/upper-case (str ord-promo))] 
                          (if (or (and (< 0 cid) (= 0 oid))
                                  (and (< 0 oid) (not= req-promo ord-promo)))
                            [cid req-promo])))]
  
  (def display-name (cell (u/capitalize-name (str first-name " " last-name))))
  (def order-step   (cell (cond (not (map? state))                        1
                                (= 0 (:address_id (:orderAddress state))) 2
                                (< 1 (js/Number (:balance state)))        3
                                :else                                     4)))

  (defn login! [email passwd]
    (m-login email passwd @brand @promo))

  (defn contact! [first last gender email email2 pass pass2 phone agree]
    (m-contact @brand first last gender email email2 pass pass2 phone agree @promo))

  (defn shipping! [addr addr2 city st zip promote]
    (let [{cid :clientID {oid :order_id} :order} @state]
      (m-ship cid oid addr addr2 city st zip promote)))

  (defn billing! [existing? addr addr2 city st zip ccname ccnum exp-m exp-y cvv]
    (let [{cid :clientID {oid :order_id} :order} @state]
      (m-bill oid existing? cid addr addr2 city st zip ccname ccnum exp-m exp-y cvv)))

  (defn init [b]
    (reset! w/keywordize true)
    (reset! brand b)
    (w/async (m-info @promo) state) 
    (cell (#(if % (apply m-replace %)) reorder))
    (cell (#(if % (reset! use-existing-cc true)) (:paymentMech state)))))
