(ns refactor-nrepl.ns.tracker
  (:require [mranderson048.toolsnamespace.v0v3v0-alpha3.clojure.tools.namespace
             [dependency :as dep]
             [file :as file]
             [track :as tracker]]
            [refactor-nrepl.core :as core]))

(defn build-tracker
  "Build a tracker for the project.

  If file-predicate is provided, use that instead of `core/source-file?`"
  ([]
   (build-tracker core/source-file?))
  ([file-predicate]
   (file/add-files (tracker/tracker) (core/find-in-project file-predicate))))

(defn get-dependents
  "Get the dependent files for ns from tracker."
  [tracker my-ns]
  (let [deps (dep/immediate-dependents (:mranderson048.toolsnamespace.v0v3v0-alpha3.clojure.tools.namespace.track/deps tracker)
                                       (symbol my-ns))]
    (for [[file ns] (:mranderson048.toolsnamespace.v0v3v0-alpha3.clojure.tools.namespace.file/filemap tracker)
          :when ((set deps) ns)]
      file)))

(defn project-files-in-topo-order []
  (let [tracker (build-tracker core/clj-file?)
        nses (dep/topo-sort (:mranderson048.toolsnamespace.v0v3v0-alpha3.clojure.tools.namespace.track/deps tracker))
        filemap (:mranderson048.toolsnamespace.v0v3v0-alpha3.clojure.tools.namespace.file/filemap tracker)
        ns2file (zipmap (vals filemap) (keys filemap))]
    (->> (map ns2file nses)
         (remove nil?))))
