(ns test.tree.sauce
  (:require [sauce-api.jobs :as job]))

;; FIXME don't forget to add build data - should be a closure passed in along w webdriver

(defn wrap-sauce
  "Run the tests in saucelabs. sauce-user and sauce-key are your
  credentials.  sauce-job-attributes-fn should be a function of the
  test, and return a map of sauce attributes to set before the test
  starts. eg {:name 'foo', :tags ['mytag'], :build 98}. 'webdriver'
  should be passed in from an outer wrapping function."
  [runner {:keys [sauce-user sauce-key sauce-job-attributes-fn]}]
  (fn [{:keys [test webdriver] :as req}]
    (let [job-id (second (re-find #"\(([^\)]+)\)" (-> webdriver :webdriver str)))
          job-attrs (sauce-job-attributes-fn test)]
      ;; give the job a name before starting
      (try (job/update-id sauce-user sauce-key job-id job-attrs)
           (catch Exception _))
      (let [res (assoc (runner req) :sauce (try (job/get-id sauce-user sauce-key job-id)
                                                (catch Exception e e)))
            passed? (-> res :result (= :pass))]
        (try (job/update-id sauce-user sauce-key job-id
                            {:passed passed?
                             :custom-data (if-not passed?
                                            {"throwable" (try (pr-str (:error res)) (catch Exception _ "could not print"))
                                             "stacktrace" (-> res :error :stack-trace java.util.Arrays/toString)}
                                            {})})
             ;; return result
             res
             (catch Exception e
               (assoc res :sauce-error e)))))))

