(defproject tendant/saml20-clj "0.1.6-wl-2"
  :description "Basic SAML 2.0 library for SSO."
  :url "https://github.com/vlacs/saml20-clj"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :source-paths ["src"]
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [clj-time "0.11.0"]
                 [ring "1.4.0"]
                 [org.apache.santuario/xmlsec "2.0.4"]
                 [compojure "1.5.0"]
                 [org.opensaml/opensaml "2.6.4"]
                 [org.clojure/data.xml "0.0.7"]
                 [org.clojure/data.codec "0.1.0"]
                 [org.clojure/data.zip "0.1.1"]
                 [org.vlacs/helmsman "1.0.0-alpha5"]]
  :pedantic :warn
  :profiles {:dev {:source-paths ["dev" "test"]
                   :dependencies [[org.clojure/tools.namespace "0.2.10"]
                                  [org.clojure/tools.nrepl "0.2.3"]
                                  [hiccup "1.0.5"]
                                  [http-kit "2.1.18"]]}}
  :plugins [[s3-wagon-private "1.1.2"]]
  :repositories [["private" {:url "s3p://eng-repos/libs/releases/"
                             :username ~(System/getenv "ENG_AWS_ACCESS_KEY_ID")
                             :passphrase ~(System/getenv "ENG_AWS_SECRET_ACCESS_KEY")
                             :sign-releases false}]])
