(ns template.view
  (:require [clojure.java.io :as io]
            [clojure.edn :as edn]
            [selmer.parser :as parser]))

(defn missing-value-fn [tag context-map]
  ; (throw (Exception. (format "NO value for tag: %s" tag)))
  (str "<Missing value: " (or (:tag-value tag) (:tag-name tag)) ">"))

(selmer.util/set-missing-value-formatter! missing-value-fn)

(defn generate-view
  [view-path context-path]
  (if-let [context (and context-path
                        (io/resource context-path))]
    (parser/render-file view-path (edn/read-string (slurp context)))
    (parser/render-file view-path {})))