(ns template.email
  (:require [clojure.java.io :as io]
            [selmer.parser :as parser]))

(defn missing-value-fn [tag context-map]
  ; (throw (Exception. (format "NO value for tag: %s" tag)))
  (str "<Missing value: " (or (:tag-value tag) (:tag-name tag)) ">"))

(defn template-resource
  [template]
  ;; (println "exists?: " (str "templates/notification/" template))
  (io/resource template))

(parser/add-tag! :footer
                 (fn [args context-map]
                   (let [type (or (:type context-map)
                                  "email") ;email
                         ext (or (:ext context-map)
                                 "html") ;html or text
                         tenant (:tenant context-map)
                         locale (:locale context-map)
                         candidates [(format "templates/notification/%s/%s/footer.%s.%s" tenant locale type ext)
                                     (format "templates/notification/%s/footer.%s.%s" locale type ext)
                                     (format "templates/notification/%s/footer.%s.%s" tenant type ext)
                                     (format "templates/notification/footer.%s.%s" type ext)]
                         result (some template-resource candidates)]
                    ;;  (println "add-tag!: result" result)
                     (slurp result))))

(parser/add-tag! :header
                 (fn [args context-map]
                   (let [type (or (:type context-map)
                                  "email") ;email
                         ext (or (:ext context-map)
                                 "html") ;html or text
                         tenant (:tenant context-map)
                         locale (:locale context-map)
                         candidates [(format "templates/notification/%s/%s/header.%s.%s" tenant locale type ext)
                                     (format "templates/notification/%s/header.%s.%s" locale type ext)
                                     (format "templates/notification/%s/header.%s.%s" tenant type ext)
                                     (format "templates/notification/header.%s.%s" type ext)]
                         result (some template-resource candidates)]
      ;; (println "add-tag!: result" result)
                     (slurp result))))


(selmer.util/set-missing-value-formatter! missing-value-fn)

(defn template-file
  [kind type ext tenant locale]
  (let [candidates [(format "templates/notification/%s/%s/%s.%s.%s" tenant locale kind type ext)
                    (format "templates/notification/%s/%s.%s.%s" locale kind type ext)
                    (format "templates/notification/%s/%s.%s.%s" tenant kind type ext)
                    (format "templates/notification/%s.%s.%s" kind type ext)]
        result (some template-resource candidates)]
    result))

(defn render-string [s context]
  (parser/render s context))

(defn render-resource [file context]
  ;; (println "RENDERRING RESOURCE:" file "with CONTEXT:" context)
  (parser/render-file file context))


(defn generate-payload
  [kind tenant locale context]
  (let [text-template (template-file kind "email" "txt" tenant locale)
        html-template (template-file kind "email" "html" tenant locale)]
    (if (or text-template html-template)
      (cond-> {:from (render-string "{{from|safe}}" context)
               :to (render-string "{{to|safe}}" context)
               :subject (render-string "{{subject}}" context)}
        text-template (assoc :text (render-resource text-template context))
        html-template (assoc :html (render-resource html-template context))
        (:cc context) (assoc :cc (render-string "{{cc|safe}}" context))
        (:bcc context) (assoc :bcc (render-string "{{bcc|safe}}" context)))
      (throw (ex-info "Template File Not Found" {:kind kind
                                                 :tenant tenant
                                                 :locale locale})))))
