(ns template.handler
  (:require [compojure.core :refer :all]
            [compojure.route :as route]
            [ring.middleware.defaults :refer [wrap-defaults site-defaults]]
            [ring.middleware.reload :refer [wrap-reload]]
            [org.httpkit.server :as http]
            [template.email :as email]
            [hiccup.core :refer :all]))

(defn process-email-notification [record]
  (let [kind (:kind record)
        tenant (:tenant record)
        context (get-in record [:body :context])
        locale (or (:locale record) "en_US")
        payload (email/generate-payload kind tenant locale context)]
    ;; (println "tenant-key:" tenant)
    ;; (println "payload:" payload)
    payload))

;; return html
(defn generate-template
  [record]
  (let [{:keys [kind type tenant ext locale]} record
        template-file (email/template-file kind type ext tenant locale)]
    template-file))

;; put template under one of the following folder
;; (format "templates/notification/%s/%s/%s.%s.%s" tenant locale kind type ext)
;; (format "templates/notification/%s/%s.%s.%s" tenant kind type ext)
;; (format "templates/notification/%s.%s.%s" kind type ext)
;; kind is template-name
;; extension is either .html or .txt
(defroutes app-routes
  (GET "/" [] "Hello Worlds")
  (GET "/:template-name/:type/:ext" [type ext template-name :as request]
    (let [template (generate-template {:kind template-name
                              :type type
                              :ext ext
                              :tenant nil
                              :locale nil})]
      template))
  (GET "/:template-name/:type/:ext/:tenant-name" [type ext template-name tenant-name :as request]
    (let []
      (generate-template {:kind template-name
                          :type type
                          :ext ext
                          :tenant tenant-name
                          :locale nil})))
  (GET "/:template-name/:type/:ext/:tenant-name/:locale" [type ext template-name tenant-name locale :as request]
    (let []
      (generate-template {:kind template-name
                          :type type
                          :ext ext
                          :tenant tenant-name
                          :locale locale})))
  (GET "/template-list" []
    (let [directory (clojure.java.io/file "src/templates")
          files (file-seq directory)]
      (html [:ul
             (map #(vector :li %) files)])))
  (route/not-found "Not Found"))

(def app
  (-> (wrap-reload #'app-routes)
      (wrap-reload)))

(defn -main  [& args]
  (let [port (try
               (Integer/parseInt (first args))
               (catch Exception _
                 9090))]
    (http/run-server app {:port port})
    (printf "Server started on port %s....%n" port)))
