(ns template.email
  (:require [clojure.java.io :as io]
            [selmer.parser :as parser]))

(defn missing-value-fn [tag context-map]
  ; (throw (Exception. (format "NO value for tag: %s" tag)))
  (str "<Missing value: " (or (:tag-value tag) (:tag-name tag)) ">"))

(defn template-resource
  [template]
  ;; (println "exists?: " (str "templates/notification/" template))
  (io/resource template))

(parser/add-tag! :footer
                 (fn [args context-map]
                   (let [t "email"
                         ext "html"
                         tenant (:tenant context-map)
                         candidates [(format "templates/notification/%s/footer.%s.%s" tenant t ext)
                                     (format "templates/notification/footer.%s.%s" t ext)]
                         result (some template-resource candidates)]
      ;; (println "add-tag!: result" result)
                     (slurp result))))

(parser/add-tag! :header
                 (fn [args context-map]
                   (let [t "email"
                         ext "html"
                         tenant (:tenant context-map)
                         candidates [(format "templates/notification/%s/header.%s.%s" tenant t ext)
                                     (format "templates/notification/header.%s.%s" t ext)]
                         result (some template-resource candidates)]
      ;; (println "add-tag!: result" result)
                     (slurp result))))


(selmer.util/set-missing-value-formatter! missing-value-fn)

(defn template-file
  [kind type ext tenant locale]
  (let [candidates [(format "templates/notification/%s/%s/%s.%s.%s" tenant locale kind type ext)
                    (format "templates/notification/%s/%s.%s.%s" tenant kind type ext)
                    (format "templates/notification/%s.%s.%s" kind type ext)]
        result (some template-resource candidates)]
    result))

(defn render-string [s context]
  (parser/render s context))

(defn render-resource [file context]
  ;; (println "RENDERRING RESOURCE:" file "with CONTEXT:" context)
  (parser/render-file file context))


(defn generate-payload
  [kind tenant locale context]
  (let [text-template (template-file kind "email" "txt" tenant locale)
        html-template (template-file kind "email" "html" tenant locale)]
    (if (or text-template html-template)
      (cond-> {:from (render-string "{{from-email|safe}}" context)
               :to (render-string "{{to-emails|safe}}" context)
               :subject (render-string "{{subject}}" context)}
        text-template (assoc :text (render-resource text-template context))
        html-template (assoc :html (render-resource html-template context))
        (:cc-emails context) (assoc :cc (render-string "{{cc-emails|safe}}" context))
        (:bcc-emails context) (assoc :bcc (render-string "{{bcc-emails|safe}}" context)))
      (throw (ex-info "Template File Not Found" {:kind kind
                                                 :tenant tenant
                                                 :locale locale})))))
