// Compiled by ClojureScript 1.10.238 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_36887 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));

try{try{var seq__36888 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__36889 = null;
var count__36890 = (0);
var i__36891 = (0);
while(true){
if((i__36891 < count__36890)){
var vec__36892 = cljs.core._nth.call(null,chunk__36889,i__36891);
var effect_key = cljs.core.nth.call(null,vec__36892,(0),null);
var effect_value = cljs.core.nth.call(null,vec__36892,(1),null);
var temp__5455__auto___36908 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___36908)){
var effect_fn_36909 = temp__5455__auto___36908;
effect_fn_36909.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__36910 = seq__36888;
var G__36911 = chunk__36889;
var G__36912 = count__36890;
var G__36913 = (i__36891 + (1));
seq__36888 = G__36910;
chunk__36889 = G__36911;
count__36890 = G__36912;
i__36891 = G__36913;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__36888);
if(temp__5457__auto__){
var seq__36888__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36888__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__36888__$1);
var G__36914 = cljs.core.chunk_rest.call(null,seq__36888__$1);
var G__36915 = c__4319__auto__;
var G__36916 = cljs.core.count.call(null,c__4319__auto__);
var G__36917 = (0);
seq__36888 = G__36914;
chunk__36889 = G__36915;
count__36890 = G__36916;
i__36891 = G__36917;
continue;
} else {
var vec__36895 = cljs.core.first.call(null,seq__36888__$1);
var effect_key = cljs.core.nth.call(null,vec__36895,(0),null);
var effect_value = cljs.core.nth.call(null,vec__36895,(1),null);
var temp__5455__auto___36918 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___36918)){
var effect_fn_36919 = temp__5455__auto___36918;
effect_fn_36919.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__36920 = cljs.core.next.call(null,seq__36888__$1);
var G__36921 = null;
var G__36922 = (0);
var G__36923 = (0);
seq__36888 = G__36920;
chunk__36889 = G__36921;
count__36890 = G__36922;
i__36891 = G__36923;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__36492__auto___36924 = re_frame.interop.now.call(null);
var duration__36493__auto___36925 = (end__36492__auto___36924 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__36493__auto___36925,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__36492__auto___36924);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_36887;
}} else {
var seq__36898 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__36899 = null;
var count__36900 = (0);
var i__36901 = (0);
while(true){
if((i__36901 < count__36900)){
var vec__36902 = cljs.core._nth.call(null,chunk__36899,i__36901);
var effect_key = cljs.core.nth.call(null,vec__36902,(0),null);
var effect_value = cljs.core.nth.call(null,vec__36902,(1),null);
var temp__5455__auto___36926 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___36926)){
var effect_fn_36927 = temp__5455__auto___36926;
effect_fn_36927.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__36928 = seq__36898;
var G__36929 = chunk__36899;
var G__36930 = count__36900;
var G__36931 = (i__36901 + (1));
seq__36898 = G__36928;
chunk__36899 = G__36929;
count__36900 = G__36930;
i__36901 = G__36931;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__36898);
if(temp__5457__auto__){
var seq__36898__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36898__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__36898__$1);
var G__36932 = cljs.core.chunk_rest.call(null,seq__36898__$1);
var G__36933 = c__4319__auto__;
var G__36934 = cljs.core.count.call(null,c__4319__auto__);
var G__36935 = (0);
seq__36898 = G__36932;
chunk__36899 = G__36933;
count__36900 = G__36934;
i__36901 = G__36935;
continue;
} else {
var vec__36905 = cljs.core.first.call(null,seq__36898__$1);
var effect_key = cljs.core.nth.call(null,vec__36905,(0),null);
var effect_value = cljs.core.nth.call(null,vec__36905,(1),null);
var temp__5455__auto___36936 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___36936)){
var effect_fn_36937 = temp__5455__auto___36936;
effect_fn_36937.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__36938 = cljs.core.next.call(null,seq__36898__$1);
var G__36939 = null;
var G__36940 = (0);
var G__36941 = (0);
seq__36898 = G__36938;
chunk__36899 = G__36939;
count__36900 = G__36940;
i__36901 = G__36941;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__36942 = cljs.core.seq.call(null,value);
var chunk__36943 = null;
var count__36944 = (0);
var i__36945 = (0);
while(true){
if((i__36945 < count__36944)){
var map__36946 = cljs.core._nth.call(null,chunk__36943,i__36945);
var map__36946__$1 = ((((!((map__36946 == null)))?(((((map__36946.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36946.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36946):map__36946);
var effect = map__36946__$1;
var ms = cljs.core.get.call(null,map__36946__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__36946__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__36942,chunk__36943,count__36944,i__36945,map__36946,map__36946__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__36942,chunk__36943,count__36944,i__36945,map__36946,map__36946__$1,effect,ms,dispatch))
,ms);
}


var G__36950 = seq__36942;
var G__36951 = chunk__36943;
var G__36952 = count__36944;
var G__36953 = (i__36945 + (1));
seq__36942 = G__36950;
chunk__36943 = G__36951;
count__36944 = G__36952;
i__36945 = G__36953;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__36942);
if(temp__5457__auto__){
var seq__36942__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36942__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__36942__$1);
var G__36954 = cljs.core.chunk_rest.call(null,seq__36942__$1);
var G__36955 = c__4319__auto__;
var G__36956 = cljs.core.count.call(null,c__4319__auto__);
var G__36957 = (0);
seq__36942 = G__36954;
chunk__36943 = G__36955;
count__36944 = G__36956;
i__36945 = G__36957;
continue;
} else {
var map__36948 = cljs.core.first.call(null,seq__36942__$1);
var map__36948__$1 = ((((!((map__36948 == null)))?(((((map__36948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36948.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36948):map__36948);
var effect = map__36948__$1;
var ms = cljs.core.get.call(null,map__36948__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__36948__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__36942,chunk__36943,count__36944,i__36945,map__36948,map__36948__$1,effect,ms,dispatch,seq__36942__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__36942,chunk__36943,count__36944,i__36945,map__36948,map__36948__$1,effect,ms,dispatch,seq__36942__$1,temp__5457__auto__))
,ms);
}


var G__36958 = cljs.core.next.call(null,seq__36942__$1);
var G__36959 = null;
var G__36960 = (0);
var G__36961 = (0);
seq__36942 = G__36958;
chunk__36943 = G__36959;
count__36944 = G__36960;
i__36945 = G__36961;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__36962 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__36963 = null;
var count__36964 = (0);
var i__36965 = (0);
while(true){
if((i__36965 < count__36964)){
var event = cljs.core._nth.call(null,chunk__36963,i__36965);
re_frame.router.dispatch.call(null,event);


var G__36966 = seq__36962;
var G__36967 = chunk__36963;
var G__36968 = count__36964;
var G__36969 = (i__36965 + (1));
seq__36962 = G__36966;
chunk__36963 = G__36967;
count__36964 = G__36968;
i__36965 = G__36969;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__36962);
if(temp__5457__auto__){
var seq__36962__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36962__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__36962__$1);
var G__36970 = cljs.core.chunk_rest.call(null,seq__36962__$1);
var G__36971 = c__4319__auto__;
var G__36972 = cljs.core.count.call(null,c__4319__auto__);
var G__36973 = (0);
seq__36962 = G__36970;
chunk__36963 = G__36971;
count__36964 = G__36972;
i__36965 = G__36973;
continue;
} else {
var event = cljs.core.first.call(null,seq__36962__$1);
re_frame.router.dispatch.call(null,event);


var G__36974 = cljs.core.next.call(null,seq__36962__$1);
var G__36975 = null;
var G__36976 = (0);
var G__36977 = (0);
seq__36962 = G__36974;
chunk__36963 = G__36975;
count__36964 = G__36976;
i__36965 = G__36977;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__36978 = cljs.core.seq.call(null,value);
var chunk__36979 = null;
var count__36980 = (0);
var i__36981 = (0);
while(true){
if((i__36981 < count__36980)){
var event = cljs.core._nth.call(null,chunk__36979,i__36981);
clear_event.call(null,event);


var G__36982 = seq__36978;
var G__36983 = chunk__36979;
var G__36984 = count__36980;
var G__36985 = (i__36981 + (1));
seq__36978 = G__36982;
chunk__36979 = G__36983;
count__36980 = G__36984;
i__36981 = G__36985;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__36978);
if(temp__5457__auto__){
var seq__36978__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36978__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__36978__$1);
var G__36986 = cljs.core.chunk_rest.call(null,seq__36978__$1);
var G__36987 = c__4319__auto__;
var G__36988 = cljs.core.count.call(null,c__4319__auto__);
var G__36989 = (0);
seq__36978 = G__36986;
chunk__36979 = G__36987;
count__36980 = G__36988;
i__36981 = G__36989;
continue;
} else {
var event = cljs.core.first.call(null,seq__36978__$1);
clear_event.call(null,event);


var G__36990 = cljs.core.next.call(null,seq__36978__$1);
var G__36991 = null;
var G__36992 = (0);
var G__36993 = (0);
seq__36978 = G__36990;
chunk__36979 = G__36991;
count__36980 = G__36992;
i__36981 = G__36993;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map?rel=1524604013326
