// Compiled by ClojureScript 1.10.238 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_36321 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));

try{try{var seq__36322 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__36323 = null;
var count__36324 = (0);
var i__36325 = (0);
while(true){
if((i__36325 < count__36324)){
var vec__36326 = cljs.core._nth.call(null,chunk__36323,i__36325);
var effect_key = cljs.core.nth.call(null,vec__36326,(0),null);
var effect_value = cljs.core.nth.call(null,vec__36326,(1),null);
var temp__5455__auto___36342 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___36342)){
var effect_fn_36343 = temp__5455__auto___36342;
effect_fn_36343.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__36344 = seq__36322;
var G__36345 = chunk__36323;
var G__36346 = count__36324;
var G__36347 = (i__36325 + (1));
seq__36322 = G__36344;
chunk__36323 = G__36345;
count__36324 = G__36346;
i__36325 = G__36347;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__36322);
if(temp__5457__auto__){
var seq__36322__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36322__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__36322__$1);
var G__36348 = cljs.core.chunk_rest.call(null,seq__36322__$1);
var G__36349 = c__4319__auto__;
var G__36350 = cljs.core.count.call(null,c__4319__auto__);
var G__36351 = (0);
seq__36322 = G__36348;
chunk__36323 = G__36349;
count__36324 = G__36350;
i__36325 = G__36351;
continue;
} else {
var vec__36329 = cljs.core.first.call(null,seq__36322__$1);
var effect_key = cljs.core.nth.call(null,vec__36329,(0),null);
var effect_value = cljs.core.nth.call(null,vec__36329,(1),null);
var temp__5455__auto___36352 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___36352)){
var effect_fn_36353 = temp__5455__auto___36352;
effect_fn_36353.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__36354 = cljs.core.next.call(null,seq__36322__$1);
var G__36355 = null;
var G__36356 = (0);
var G__36357 = (0);
seq__36322 = G__36354;
chunk__36323 = G__36355;
count__36324 = G__36356;
i__36325 = G__36357;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__36161__auto___36358 = re_frame.interop.now.call(null);
var duration__36162__auto___36359 = (end__36161__auto___36358 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__36162__auto___36359,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__36161__auto___36358);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_36321;
}} else {
var seq__36332 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__36333 = null;
var count__36334 = (0);
var i__36335 = (0);
while(true){
if((i__36335 < count__36334)){
var vec__36336 = cljs.core._nth.call(null,chunk__36333,i__36335);
var effect_key = cljs.core.nth.call(null,vec__36336,(0),null);
var effect_value = cljs.core.nth.call(null,vec__36336,(1),null);
var temp__5455__auto___36360 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___36360)){
var effect_fn_36361 = temp__5455__auto___36360;
effect_fn_36361.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__36362 = seq__36332;
var G__36363 = chunk__36333;
var G__36364 = count__36334;
var G__36365 = (i__36335 + (1));
seq__36332 = G__36362;
chunk__36333 = G__36363;
count__36334 = G__36364;
i__36335 = G__36365;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__36332);
if(temp__5457__auto__){
var seq__36332__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36332__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__36332__$1);
var G__36366 = cljs.core.chunk_rest.call(null,seq__36332__$1);
var G__36367 = c__4319__auto__;
var G__36368 = cljs.core.count.call(null,c__4319__auto__);
var G__36369 = (0);
seq__36332 = G__36366;
chunk__36333 = G__36367;
count__36334 = G__36368;
i__36335 = G__36369;
continue;
} else {
var vec__36339 = cljs.core.first.call(null,seq__36332__$1);
var effect_key = cljs.core.nth.call(null,vec__36339,(0),null);
var effect_value = cljs.core.nth.call(null,vec__36339,(1),null);
var temp__5455__auto___36370 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___36370)){
var effect_fn_36371 = temp__5455__auto___36370;
effect_fn_36371.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__36372 = cljs.core.next.call(null,seq__36332__$1);
var G__36373 = null;
var G__36374 = (0);
var G__36375 = (0);
seq__36332 = G__36372;
chunk__36333 = G__36373;
count__36334 = G__36374;
i__36335 = G__36375;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__36376 = cljs.core.seq.call(null,value);
var chunk__36377 = null;
var count__36378 = (0);
var i__36379 = (0);
while(true){
if((i__36379 < count__36378)){
var map__36380 = cljs.core._nth.call(null,chunk__36377,i__36379);
var map__36380__$1 = ((((!((map__36380 == null)))?(((((map__36380.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36380.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36380):map__36380);
var effect = map__36380__$1;
var ms = cljs.core.get.call(null,map__36380__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__36380__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__36376,chunk__36377,count__36378,i__36379,map__36380,map__36380__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__36376,chunk__36377,count__36378,i__36379,map__36380,map__36380__$1,effect,ms,dispatch))
,ms);
}


var G__36384 = seq__36376;
var G__36385 = chunk__36377;
var G__36386 = count__36378;
var G__36387 = (i__36379 + (1));
seq__36376 = G__36384;
chunk__36377 = G__36385;
count__36378 = G__36386;
i__36379 = G__36387;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__36376);
if(temp__5457__auto__){
var seq__36376__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36376__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__36376__$1);
var G__36388 = cljs.core.chunk_rest.call(null,seq__36376__$1);
var G__36389 = c__4319__auto__;
var G__36390 = cljs.core.count.call(null,c__4319__auto__);
var G__36391 = (0);
seq__36376 = G__36388;
chunk__36377 = G__36389;
count__36378 = G__36390;
i__36379 = G__36391;
continue;
} else {
var map__36382 = cljs.core.first.call(null,seq__36376__$1);
var map__36382__$1 = ((((!((map__36382 == null)))?(((((map__36382.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36382.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36382):map__36382);
var effect = map__36382__$1;
var ms = cljs.core.get.call(null,map__36382__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__36382__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__36376,chunk__36377,count__36378,i__36379,map__36382,map__36382__$1,effect,ms,dispatch,seq__36376__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__36376,chunk__36377,count__36378,i__36379,map__36382,map__36382__$1,effect,ms,dispatch,seq__36376__$1,temp__5457__auto__))
,ms);
}


var G__36392 = cljs.core.next.call(null,seq__36376__$1);
var G__36393 = null;
var G__36394 = (0);
var G__36395 = (0);
seq__36376 = G__36392;
chunk__36377 = G__36393;
count__36378 = G__36394;
i__36379 = G__36395;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__36396 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__36397 = null;
var count__36398 = (0);
var i__36399 = (0);
while(true){
if((i__36399 < count__36398)){
var event = cljs.core._nth.call(null,chunk__36397,i__36399);
re_frame.router.dispatch.call(null,event);


var G__36400 = seq__36396;
var G__36401 = chunk__36397;
var G__36402 = count__36398;
var G__36403 = (i__36399 + (1));
seq__36396 = G__36400;
chunk__36397 = G__36401;
count__36398 = G__36402;
i__36399 = G__36403;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__36396);
if(temp__5457__auto__){
var seq__36396__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36396__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__36396__$1);
var G__36404 = cljs.core.chunk_rest.call(null,seq__36396__$1);
var G__36405 = c__4319__auto__;
var G__36406 = cljs.core.count.call(null,c__4319__auto__);
var G__36407 = (0);
seq__36396 = G__36404;
chunk__36397 = G__36405;
count__36398 = G__36406;
i__36399 = G__36407;
continue;
} else {
var event = cljs.core.first.call(null,seq__36396__$1);
re_frame.router.dispatch.call(null,event);


var G__36408 = cljs.core.next.call(null,seq__36396__$1);
var G__36409 = null;
var G__36410 = (0);
var G__36411 = (0);
seq__36396 = G__36408;
chunk__36397 = G__36409;
count__36398 = G__36410;
i__36399 = G__36411;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__36412 = cljs.core.seq.call(null,value);
var chunk__36413 = null;
var count__36414 = (0);
var i__36415 = (0);
while(true){
if((i__36415 < count__36414)){
var event = cljs.core._nth.call(null,chunk__36413,i__36415);
clear_event.call(null,event);


var G__36416 = seq__36412;
var G__36417 = chunk__36413;
var G__36418 = count__36414;
var G__36419 = (i__36415 + (1));
seq__36412 = G__36416;
chunk__36413 = G__36417;
count__36414 = G__36418;
i__36415 = G__36419;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__36412);
if(temp__5457__auto__){
var seq__36412__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36412__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__36412__$1);
var G__36420 = cljs.core.chunk_rest.call(null,seq__36412__$1);
var G__36421 = c__4319__auto__;
var G__36422 = cljs.core.count.call(null,c__4319__auto__);
var G__36423 = (0);
seq__36412 = G__36420;
chunk__36413 = G__36421;
count__36414 = G__36422;
i__36415 = G__36423;
continue;
} else {
var event = cljs.core.first.call(null,seq__36412__$1);
clear_event.call(null,event);


var G__36424 = cljs.core.next.call(null,seq__36412__$1);
var G__36425 = null;
var G__36426 = (0);
var G__36427 = (0);
seq__36412 = G__36424;
chunk__36413 = G__36425;
count__36414 = G__36426;
i__36415 = G__36427;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map?rel=1524514174378
