# Systemic
[![Clojars Project](https://img.shields.io/clojars/v/teknql/systemic.svg)](https://clojars.org/teknql/systemic)

Yet another state management solution for Clojure applications

## Motivation and Comparison to Other Libraries

Clojure has many fantastic solutions for application state management -
[component](https://github.com/stuartsierra/component),
[mount](https://github.com/tolitius/mount), and
[integrant](https://github.com/weavejester/integrant) are all fantastic
libraries which bring unique and valuable features to the table.

`systemic` is similar to `mount`, in that it strives to prioritize the
experience in the repl and makes use of clojure's own resolution
capabilities to implicitly define dependencies between components.

## Example

```clojure
(require '[systemic.core :as systemic :refer [defstate]])

(defstate *port*
  :start (read-string (System/getenv "APPLICATION_PORT")))

(defstate *server*
  :start (start-web-server *port*)
  :stop (shutdown-server *server*))

(systemic/start!)
```
