(defproject techascent/vault-clj "0.2.17"
  :description "Access to the hashicorp vault system from clojure"
  :url "https://www.github.com/thinktopic/vault-clj"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [techascent/tech.config "0.3.5"]
                 [cheshire "5.7.1"]
                 [http-kit "2.3.0"]]

  :plugins [[s3-wagon-private "1.3.1" :exclusions [commons-codec]]]

  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "" "--no-sign"] ; disable signing
                  ["deploy"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]

  :repositories  {"snapshots"  {:url "s3p://techascent.jars/snapshots/"
                                :no-auth true
                                :releases false}
                  "releases"  {:url "s3p://techascent.jars/releases/"
                               :no-auth ture
                               :snapshots false
                               :sign-releases false}}
  :profiles {:uberjar {:aot :all}
             :tools {:plugins [[lein-environ "1.1.0"]]
                     :dependencies [[thinktopic/think.release "0.1.0-2017-05-11-10-20"]]
                     :env {:date-version "false"}}}

  :think/meta {:type :library
               :tags [:ops :vault]}

  :aliases {"release" ["with-profile" "tools" "run" "-m" "think.release.main"]})
