(ns tvm-clj.impl.fns.target.build
  (:require [tvm-clj.impl.base :as base]))

(defonce ^:private aocl-fnptr* (delay (base/name->global-function "target.build.aocl")))
(defn aocl
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.aocl"}
   (apply base/call-function @aocl-fnptr* args)))

(defonce ^:private c-fnptr* (delay (base/name->global-function "target.build.c")))
(defn c
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.c"}
   (apply base/call-function @c-fnptr* args)))

(defonce ^:private cuda-fnptr* (delay (base/name->global-function "target.build.cuda")))
(defn cuda
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.cuda"}
   (apply base/call-function @cuda-fnptr* args)))

(defonce ^:private hexagon-fnptr* (delay (base/name->global-function "target.build.hexagon")))
(defn hexagon
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.hexagon"}
   (apply base/call-function @hexagon-fnptr* args)))

(defonce ^:private llvm-fnptr* (delay (base/name->global-function "target.build.llvm")))
(defn llvm
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.llvm"}
   (apply base/call-function @llvm-fnptr* args)))

(defonce ^:private metal-fnptr* (delay (base/name->global-function "target.build.metal")))
(defn metal
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.metal"}
   (apply base/call-function @metal-fnptr* args)))

(defonce ^:private nvptx-fnptr* (delay (base/name->global-function "target.build.nvptx")))
(defn nvptx
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.nvptx"}
   (apply base/call-function @nvptx-fnptr* args)))

(defonce ^:private opencl-fnptr* (delay (base/name->global-function "target.build.opencl")))
(defn opencl
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.opencl"}
   (apply base/call-function @opencl-fnptr* args)))

(defonce ^:private rocm-fnptr* (delay (base/name->global-function "target.build.rocm")))
(defn rocm
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.rocm"}
   (apply base/call-function @rocm-fnptr* args)))

(defonce ^:private sdaccel-fnptr* (delay (base/name->global-function "target.build.sdaccel")))
(defn sdaccel
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.sdaccel"}
   (apply base/call-function @sdaccel-fnptr* args)))

(defonce ^:private stackvm-fnptr* (delay (base/name->global-function "target.build.stackvm")))
(defn stackvm
 "TVM PackedFn"
 [& args]
 (with-bindings {#'base/fn-name "target.build.stackvm"}
   (apply base/call-function @stackvm-fnptr* args)))

