(ns tech.persist.duratom
  (:require [duratom.core :as duratom]
            [taoensso.nippy :as nippy]
            [tech.persist.protocols :as pers-proto]
            [tech.persist.utils :as utils]
            [tech.persist.atom :as persist-atom])
  (:import [java.util UUID Date]))



(defrecord Duratom [index*]
  pers-proto/PPersist
  (get-mutation-fn! [engine]
    (partial persist-atom/perform-mutations! index*))
  (index [engine] @index*)
  (latest [engine]
    (->Duratom index*)))



(defn persister
  [file-path]
  (let [index* (duratom/duratom :local-file
                                :file-path file-path
                                :init {}
                                :rw {:read nippy/thaw-from-file
                                     :write nippy/freeze-to-file})]
    (->Duratom index*)))


(defn test-persister
  "Persister that doesn't write to the filesystem"
  [& {:keys [index-data]
      :or {index-data {}}}]
  (->Duratom (atom index-data) (atom 0) (atom [])))
