(defproject techascent/tech.persist "0.1.18"
  :description "General persistence layer supporting rapid proto through initial
  stabilizing"
  :url "http://github.com/tech-ascent/tech.persistence"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :plugins [[lein-tools-deps "0.4.1"]
            [s3-wagon-private "1.3.1"]
            [lein-eftest "0.5.3"]]
  :middleware [lein-tools-deps.plugin/resolve-dependencies-with-deps-edn]
  :lein-tools-deps/config {:config-files [:install :user :project]}


  :repositories {"releases"  {:url "s3p://techascent.jars/releases/"
                              :no-auth true
                              :sign-releases false}}

  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "" "--no-sign"] ; disable signing
                  ["deploy"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]])
