# tech.persistence

Generalized persistence layer for the techascent ecosystem.


> Rapid web deployment focusing on user experience, reliability, and data integrity. See something fast, iterate quickly, and never lose data.


### Ring Usage

Ring integration comes in the form of a handler.  This handler will expect the global persister to be bound (with-persister).
It will maintain its own persist atom and it will set the global atom to the return of persist/latest.

The main repl persist var root is bound to the handler's persister so repl-ing around still works.

In one of your namespaces, make sure this code is called:
```clojure
(persist/set-config-persister!)
```

And make sure when using ring, use the provided ring handler:

```clojure
(defn handlers
  []
  (-> (route-handler)
      (persist/ring-handler)))
```


## License

Copyright © 2018 Tech Ascent, LLC

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
