(ns tech.v3.dataset.sql.datatypes
  "SQL datatypes are their own unique mess.  You are required to use their integer
  type index for setNull on prepared statements so we need a global map from
  sql type to type index.")



(def datatypes {"float" 8,
                "json" 1111,
                "pg_snapshot" 1111,
                "regconfig" 1111,
                "_xid8" 2003,
                "_box" 2003,
                "int" 4,
                "bytea" -2,
                "smalldatetime" 93,
                "anycompatiblerange" 1111,
                "numrange" 1111,
                "float8" 8,
                "double precision" 8
                "_yes_or_no" 2003,
                "cardinal_number" 2001,
                "tsrange" 1111,
                "numeric" 2,
                "anyelement" 1111,
                "_cid" 2003,
                "_character_data" 2003,
                "internal" 1111,
                "_jsonb" 2003,
                "_xml" 2003,
                "xml" -16,
                "cidr" 1111,
                "bigint identity" -5,
                "_testtable" 2003,
                "_pg_lsn" 2003,
                "_regconfig" 2003,
                "void" 1111,
                "_name" 2003,
                "daterange" 1111,
                "bit" -7,
                "_regproc" 2003,
                "_int4range" 2003,
                "serial" 4,
                "macaddr" 1111,
                "_tstzrange" 2003,
                "_tsrange" 2003,
                "_time" 2003,
                "tsquery" 1111,
                "_tsquery" 2003,
                "_uuid" 2003,
                "xid8" 1111,
                "_timetz" 2003,
                "record" 1111,
                "image" -4,
                "_float8" 2003,
                "_numrange" 2003,
                "int2vector" 1111,
                "_interval" 2003,
                "_float4" 2003,
                "time_stamp" 2001,
                "smallint identity" 5,
                "_polygon" 2003,
                "_aclitem" 2003,
                "regcollation" 1111,
                "language_handler" 1111,
                "binary" -2,
                "_regdictionary" 2003,
                "pg_dependencies" 1111,
                "_path" 2003,
                "regoperator" 1111,
                "path" 1111,
                "anynonarray" 1111,
                "uniqueidentifier" 1,
                "_txid_snapshot" 2003,
                "anyarray" 1111,
                "jsonpath" 1111,
                "pg_ndistinct" 1111,
                "timestamp" -2,
                "jsonb" 1111,
                "_point" 2003,
                "int4range" 1111,
                "_regoper" 2003,
                "nchar" -15,
                "varbinary" -3,
                "_regnamespace" 2003,
                "_regoperator" 2003,
                "box" 1111,
                "tinyint identity" -6,
                "_oid" 2003,
                "numeric() identity" 2,
                "float4" 7,
                "_numeric" 2003,
                "xid" 1111,
                "_sql_identifier" 2003,
                "_int2vector" 2003,
                "regdictionary" 1111,
                "_dtt" 2003,
                "regnamespace" 1111,
                "_timestamp" 2003,
                "bpchar" 1,
                "pg_lsn" 1111,
                "any" 1111,
                "tsm_handler" 1111,
                "_json" 2003,
                "_regclass" 2003,
                "oid" -5,
                "name" 12,
                "oidvector" 1111,
                "uuid" 1111,
                "int4" 4,
                "real" 7,
                "_inet" 2003,
                "interval" 1111,
                "inet" 1111,
                "regoper" 1111,
                "_tid" 2003,
                "_bytea" 2003,
                "smallmoney" 3,
                "bool" -7,
                "char" 1,
                "fdw_handler" 1111,
                "varbit" 1111,
                "_text" 2003,
                "tsvector" 1111,
                "bigserial" -5,
                "_regtype" 2003,
                "regprocedure" 1111,
                "anycompatiblearray" 1111,
                "text" -1,
                "_lseg" 2003,
                "anyrange" 1111,
                "_regprocedure" 2003,
                "_regrole" 2003,
                "_bpchar" 2003,
                "txid_snapshot" 1111,
                "time" 92,
                "_gtsvector" 2003,
                "_regcollation" 2003,
                "event_trigger" 1111,
                "regrole" 1111,
                "anycompatiblenonarray" 1111,
                "datetime" 93,
                "anycompatible" 1111,
                "_line" 2003,
                "_int8" 2003,
                "line" 1111,
                "datetimeoffset" -155,
                "aclitem" 1111,
                "tinyint" -6,
                "_time_stamp" 2003,
                "gtsvector" 1111,
                "pg_node_tree" 1111,
                "sql_identifier" 2001,
                "int8" -5,
                "polygon" 1111,
                "_varchar" 2003,
                "unknown" 1111,
                "decimal() identity" 3,
                "cstring" 1111,
                "regproc" 1111,
                "anyenum" 1111,
                "_daterange" 2003,
                "int2" 5,
                "sysname" -9,
                "_cardinal_number" 2003,
                "money" 3,
                "yes_or_no" 2001,
                "macaddr8" 1111,
                "refcursor" 2012,
                "_macaddr8" 2003,
                "smallint" 5,
                "_cidr" 2003,
                "_bool" 2003,
                "datetime2" 93,
                "date" 91,
                "_int2" 2003,
                "int identity" 4,
                "varchar" 12,
                "nvarchar" -9,
                "cid" 1111,
                "_macaddr" 2003,
                "_date" 2003,
                "_bit" 2003,
                "pg_mcv_list" 1111,
                "_int8range" 2003,
                "int8range" 1111,
                "_record" 2003,
                "_varbit" 2003,
                "bigint" -5,
                "index_am_handler" 1111,
                "trigger" 1111,
                "_refcursor" 2003,
                "circle" 1111,
                "_cstring" 2003,
                "_jsonpath" 2003,
                "_char" 2003,
                "_circle" 2003,
                "regclass" 1111,
                "tstzrange" 1111,
                "ntext" -16,
                "_pg_snapshot" 2003,
                "character_data" 2001,
                "_timestamptz" 2003,
                "timetz" 92,
                "timestamptz" 93,
                "_money" 2003,
                "point" 1111,
                "tid" 1111,
                "sql_variant" -150,
                "_tsvector" 2003,
                "decimal" 3,
                "_int4" 2003,
                "regtype" 1111,
                "pg_ddl_command" 1111,
                "lseg" 1111,
                "_oidvector" 2003,
                "_xid" 2003,
                "table_am_handler" 1111})


(def type-index
  (memoize
   (fn [^String sql-datatype]
     (let [sql-datatype (let [paren-idx (.indexOf sql-datatype (int \())]
                          (if-not (== -1 paren-idx)
                            (.substring sql-datatype 0 paren-idx)
                            sql-datatype))]

       (if-let [retval (get datatypes sql-datatype)]
         retval
         (throw (Exception.
                 (format "Failed to find sql type index for datatype %s" sql-datatype))))))))
