(defproject tech.gojek/corvus "1.0.0"
  :description "Sentry client to report error events asynchronously"
  :url "https://github.com/gojektech/corvus"
  :license {:name "Apache License, Version 2.0"
            :url  "https://www.apache.org/licenses/LICENSE-2.0"}
  :repl-options {:host "0.0.0.0"
                 :port 1337}
  :dependencies [[cheshire "5.8.1"]
                 [clj-http "3.9.1"]
                 [com.google.guava/guava "23.0"]
                 [org.clojure/clojure "1.9.0"]
                 [org.clojure/tools.logging "0.4.1"]
                 [prone "1.6.1"]]
  :profiles {:dev {:dependencies [[print-foo "1.0.1"]]
                   :plugins      [[jonase/eastwood "0.2.5"
                                   :exclusions [org.clojure/clojure]]
                                  [lein-ancient "0.6.15"]
                                  [lein-cloverage "1.0.13"]
                                  [lein-cljfmt "0.5.7"]
                                  [lein-codox "0.10.5"]
                                  [lein-githooks "0.1.0"]
                                  [lein-kibit "0.1.6"]]
                   :codox        {:output-path "codox"}
                   :githooks     {:pre-commit ["make format"]
                                  :pre-push   ["make coverage"]}}})
