(ns versioniq.helpers
  (:require
    [fipp.clojure :as fipp]))


(set! *warn-on-reflection* true)


(defmacro try-or
  "Returns the evaluated body and catches an exception with the given handler fn."
  {:added "0.0.1"}
  ([body]
    `(try-or ~body (constantly nil)))
  ([body handler]
    `(try
       ~body
       (catch Exception error#
         (when-some [handler# ~handler]
           (handler# error#))))))


(defn parse-keyword
  "Converts a string to a keyword."
  {:added "0.0.1"}
  [^String s]
  (if (.startsWith s ":")
    (read-string s)
    (keyword s)))


(defn keywordize
  "Returns a keyword."
  {:added "0.0.1"}
  [x]
  (cond
    (keyword? x) x
    (string? x) (parse-keyword x)))


(defn pretty-print
  "Pretty print to string."
  {:added "0.0.1"}
  [x]
  (with-out-str (fipp/pprint x)))
