(ns versioniq.config
  (:require
    [aero.core :as aero]
    [clojure.string :as str]
    [versioniq.fs :as fs]
    [versioniq.helpers :as helpers]
    [versioniq.log :as log]))


(set! *warn-on-reflection* true)


(def ^{:added "0.0.1"}
  config-file
  "Default config file name."
  ".versioniq")


(def ^{:added "0.0.1"}
  defaults
  "Default configuration."
  {:storage :git
   :tag     {:prefix    ""
             :separator ""}
   :version {:strategy  [:major :minor :patch]
             :separator "."
             :prefix    "v"
             :format    {:major   ""
                         :minor   ""
                         :patch   ""
                         :build   ""
                         :git-sha ""
                         :date    ""}}})


(defn ^String working-directory
  "Converts `path` into an absolute path.
  Without any arguments returns an absolute path for the current working directory"
  {:added "0.0.1"}
  ([]
    (working-directory "."))
  ([path]
    (str (fs/absolute-path path))))


(defn read-config
  "Reads a config using `root-directory` and `config-file` name."
  {:added "0.0.1"}
  ([]
    (read-config {}))
  ([{:keys [root-directory config-file profile]
     :or   {root-directory (working-directory)
            config-file    config-file
            profile        :default}}]
    (let [path   (str (fs/path root-directory config-file))
          opts   {:profile        (helpers/keywordize profile)
                  :root-directory root-directory
                  :config-file    config-file
                  :config-path    path}
          config (helpers/try-or
                   (aero/read-config path (select-keys opts [:profile]))
                   (fn [error]
                     (let [msg (->> [(format "Can't open the configuration file: \"%s\"" path)
                                     error
                                     "The default configuration will be used."]
                                 (str/join (System/lineSeparator)))]
                       (log/error msg)
                       {})))]
      (merge-with merge defaults config {:opts opts}))))
