(ns versioniq.config
  (:refer-clojure :exclude [read-string])
  (:require
    [clojure.tools.reader.edn :as edn]
    [versioniq.env]
    [versioniq.fs :as fs]))


(set! *warn-on-reflection* true)


(def ^{:added "0.0.1"}
  config-file
  "Default config file name."
  ".versioniq")


(defn read-string
  "Reads a config from a string of edn."
  {:added "0.0.1"}
  ([s]
    (read-string {:eof nil} s))
  ([opts s]
    (let [readers (merge *data-readers* (get opts :readers {}))]
      (edn/read-string (assoc opts :readers readers) s))))


(defn ^String working-directory
  "Converts `path` into an absolute path.
  Without any arguments returns an absolute path for the current working directory"
  {:added "0.0.1"}
  ([]
    (working-directory "."))
  ([path]
    (fs/absolute-path path)))


(defn read-config
  "Reads a config using `root-directory` and `config-file` name."
  {:added "0.0.1"}
  ([]
    (read-config {}))
  ([{:as   opts
     :keys [root-directory config-file]
     :or   {root-directory (working-directory)
            config-file    config-file}}]
    (let [path (str (fs/path root-directory config-file))]
      (try
        (-> path
          slurp
          read-string)
        (catch Exception _
          (let [msg (format "Can't open the configuration file: %s" path)]
            (throw (ex-info msg {:opts opts}))))))))
