(defproject team.sultanov/event-tree-tracker "0.1.1"
  :description "Event tree tracking interceptor for re-frame"
  :url         "https://github.com/sultanov-team/event-tree-tracker"
  :license {:name "MIT License"
            :url  "https://github.com/sultanov-team/event-tree-tracker/blob/master/LICENSE"}

  :dependencies [[org.clojure/clojure       "1.10.0-alpha4"]
                 [org.clojure/clojurescript "1.10.339" :scope "provided"]
                 [re-frame                  "0.10.5"]]

  :profiles {:debug {:debug true}
             :dev   {:dependencies [[karma-reporter     "3.1.0"]
                                    [binaryage/devtools "0.9.10"]]
                     :plugins [[lein-ancient   "0.6.15"]
                               [lein-cljsbuild "1.1.5"]
                               [lein-npm       "0.6.2"]
                               [lein-figwheel  "0.5.13"]
                               [lein-shell     "0.5.0"]]}}

  :npm {:devDependencies [[karma                 "1.0.0"]
                          [karma-cljs-test       "0.1.0"]
                          [karma-chrome-launcher "2.2.0"]
                          [karma-junit-reporter  "0.3.8"]]}

  :clean-targets  [:target-path "run/compiled"]
  :resource-paths ["run/resources"]
  :jvm-opts       ["-Xmx1g" "-XX:+UseConcMarkSweepGC"] ;; java 9+ ["--add-modules" "java.xml.bind"]

  :cljsbuild {:builds [{:id           "test"
                        :source-paths ["test" "src"]
                        :compiler     {:preloads             [devtools.preload]
                                       :external-config      {:devtools/config {:features-to-install [:formatters :hints]}}
                                       :output-to            "run/compiled/browser/test.js"
                                       :source-map           true
                                       :output-dir           "run/compiled/browser/test"
                                       :optimizations        :none
                                       :source-map-timestamp true
                                       :pretty-print         true}}
                       {:id           "karma"
                        :source-paths ["test" "src"]
                        :compiler     {:output-to       "run/compiled/karma/test.js"
                                       :source-map      "run/compiled/karma/test.js.map"
                                       :output-dir      "run/compiled/karma/test"
                                       :optimizations   :whitespace
                                       :main            "event_tree_tracker.test_runner"
                                       :pretty-print    true
                                       :closure-defines {"re_frame.trace.trace_enabled_QMARK_" true}}}]}

  :shell {:commands {"open" {:windows ["cmd" "/c" "start"]
                             :macosx  "open"
                             :linux   "xdg-open"}}}

  :scm {:name "git"
        :url  "https://github.com/sultanov-team/event-tree-tracker"}

  :deploy-branches     ["master"]
  :deploy-repositories [["snapshots" {:url      "https://clojars.org/repo"
                                      :username [:gpg :env/sultanov_team_clojars_username]
                                      :password [:gpg :env/sultanov_team_clojars_password]}]
                        ["releases"  {:url      "https://clojars.org/repo"
                                      :username [:gpg :env/sultanov_team_clojars_username]
                                      :password [:gpg :env/sultanov_team_clojars_password]}]])
