(defproject team.sultanov/event-tree-tracker "0.1.0"
  :description  "Event tree tracking interceptor for re-frame"
  :url          "https://github.com/sultanov-team/event-tree-tracker"
  :license      {:name "MIT License"
                 :url  "https://github.com/sultanov-team/event-tree-tracker/blob/master/LICENSE"}

  :dependencies [[org.clojure/clojure "1.10.0-alpha4" :scope "provided"]
                 [org.clojure/clojurescript "1.10.339" :scope "provided"]
                 [re-frame "0.10.5"]]

  ;; :jvm-opts ["--add-modules" "java.xml.bind"]

  :profiles {:dev {:plugins [[lein-ancient                      "0.6.15"]
                             [com.jakemccrary/lein-test-refresh "0.22.0"]]
                   :repl-options {:host "0.0.0.0"
                                  :port 7000}}}

  :scm {:name "git"
        :url  "https://github.com/sultanov-team/event-tree-tracker"}

  :deploy-branches     ["master"]
  :deploy-repositories [["snapshots" {:url      "https://clojars.org/repo"
                                      :username [:gpg :env/sultanov_team_clojars_username]
                                      :password [:gpg :env/sultanov_team_clojars_password]}]
                        ["releases"  {:url      "https://clojars.org/repo"
                                      :username [:gpg :env/sultanov_team_clojars_username]
                                      :password [:gpg :env/sultanov_team_clojars_password]}]])
