(ns clj-kafka.consumers
  (:require [clj-kafka.commons :as commons]
            [clj-kafka.serialization.core :as serialization])
  (:import [org.apache.kafka.clients.consumer Consumer KafkaConsumer ConsumerRecord]))


(defn consumer
  ([properties]
   (consumer properties nil nil))

  ([properties value-deserializer]
   (consumer properties nil value-deserializer))

  ([properties key-deserializer value-deserializer]
   (let [p  (commons/to-properties properties)
         kd (or key-deserializer   (serialization/deserializer :string))
         vd (or value-deserializer (serialization/deserializer :string))]
     (KafkaConsumer. p kd vd))))
