(defproject team.sultanov/clj-kafka "0.1.0"
  :description    "Clojure library for Apache Kafka"
  :url            "https://github.com/sultanov-team/clj-kafka"
  :license        {:name "MIT License"
                   :url  "https://github.com/sultanov-team/clj-kafka/blob/master/LICENSE"}

  :dependencies   [[org.clojure/clojure            "1.9.0"]
                   [org.apache.kafka/kafka-clients "1.0.0"]
                   [com.cognitect/transit-clj      "0.8.300"]
                   [metosin/jsonista               "0.1.1"]]

  :profiles       {:dev {:plugins      [[lein-ancient                      "0.6.15"]
                                        [com.jakemccrary/lein-test-refresh "0.22.0"]]
                         :repl-options {:host "0.0.0.0"
                                        :port 7000}}}
  :scm            {:name "git"
                   :url  "https://github.com/sultanov-team/clj-kafka"}
  :deploy-branches     ["master"]
  :deploy-repositories [["snapshots" {:url      "https://clojars.org/repo"
                                      :username [:gpg :env/clojars_username]
                                      :password [:gpg :env/clojars_password]}]
                        ["releases"  {:url      "https://clojars.org/repo"
                                      :username [:gpg :env/clojars_username]
                                      :password [:gpg :env/clojars_password]}]])
