(ns clj-google-maps.config)

;;
;; helpers
;;

(defn- get-env-variable [key]
  (or (System/getenv key)
      (throw (IllegalArgumentException. (format "\"%s\" not found in your environment variables." key)))))


;;
;; google-maps api configuration
;;

(def ^:const api-url      (get-env-variable "GOOGLE_MAPS_API_URL"))
(def ^:const api-key      (get-env-variable "GOOGLE_MAPS_API_KEY"))
(def ^:const api-region   (get-env-variable "GOOGLE_MAPS_API_REGION"))
(def ^:const api-language (get-env-variable "GOOGLE_MAPS_API_LANGUAGE"))
(def ^:const api-format   (get-env-variable "GOOGLE_MAPS_API_FORMAT"))
