(ns
  #^{:author "Tom Savage"}
  examples.tree
  (:require [data.adts :refer :all]))

;
; A simple tree structure defined as an algebraic data type.
;
(defadt ::tree
  empty-tree
  (leaf value)
  (node left-tree right-tree))

(def a-tree
  (node
   (leaf :a)
   (node
    (leaf :b)
    (leaf :c))))

(defn depth
  [t]
  (match t
    empty-tree  0
    (leaf _)    1
    (node l r)  (inc (max (depth l) (depth r)))))

(defn show-depths []
  (println (depth empty-tree))
  (println (depth (leaf 42)))
  (println (depth a-tree)))
