(defproject tawus/reframegems "0.1.0-SNAPSHOT"
  :description "A descriptive form library for reagent, re-frame & material-ui"
  :url "http://xeric.net"
  :min-lein-version "2.7.1"

  :dependencies
  [[org.clojure/clojure "1.8.0" :scope "provided"]
   [org.clojure/clojurescript "1.9.229" :scope "provided"]
   [org.clojure/core.match "0.3.0-alpha4"]
   [reagent "0.6.0" :exclusions [cljsjs/react cljsjs/react-dom]]
   [re-frame "0.9.1" :exclusions [cljsjs/react cljsjs/react-dom]]
   [cljs-react-material-ui "0.2.37"]
   [cljsjs/react-select "1.0.0-beta13-0"
    :exclusions [cljsjs/react cljsjs/react-dom]]
   [cljsjs/material-ui-chip-input "0.12.2-0"]
   [com.taoensso/encore "2.59.0"]
   [com.taoensso/tower "3.0.2" :exclusions [com.taoensso/encore]]
   [day8.re-frame/http-fx "0.1.3"]
   [bidi "2.0.9"]
   
   [kibu/pushy "0.3.6"]]
  
  :plugins
  [[lein-figwheel "0.5.9"]
   [lein-cljsbuild "1.1.5" :exclusions [[org.clojure/clojure]]]]

  :source-paths ["src"]

  :clean-targets ^{:protect false} ["resources/public/js/compiled" "target"]

  :cljsbuild
  {:builds
   [{:id "dev"
     :source-paths ["src" "dev-cljs" "test-resources"]
     
     ;; the presence of a :figwheel configuration here
     ;; will cause figwheel to inject the figwheel client
     ;; into your build
     :figwheel
     {:on-jsload "reframegems.core/on-js-reload"
      ;; :open-urls will pop open your application
      ;; in the default browser once Figwheel has
      ;; started and complied your application.
      ;; Comment this out once it no longer serves you.
      :open-urls ["http://localhost:3449/index.html"]}
     
     :compiler
     {:main reframegems.demo
      :asset-path "js/compiled/out"
      :output-to "resources/public/js/compiled/reframegems.js"
      :output-dir "resources/public/js/compiled/out"
      :source-map-timestamp true
      ;; To console.log CLJS data-structures make sure you enable devtools in Chrome
      ;; https://github.com/binaryage/cljs-devtools
      :preloads [devtools.preload]}}
    
    ;; This next build is an compressed minified build for
    ;; production. You can build this with:
    ;; lein cljsbuild once min
    {:id "min"
     :source-paths ["src"]
     :compiler
     {:output-to "resources/public/js/compiled/reframegems.js"
      :main reframegems.core
      :optimizations :advanced
      :pretty-print false}}]}
  
  :figwheel
  {;; :http-server-root "public" ;; default and assumes "resources"
   ;; :server-port 3449 ;; default
   ;; :server-ip "127.0.0.1"
   
   :css-dirs ["resources/public/css"] ;; watch and update CSS
   
   ;; Start an nREPL server into the running figwheel process
   ;; :nrepl-port 7888
   
   ;; Server Ring Handler (optional)
   ;; if you want to embed a ring handler into the figwheel http-kit
   ;; server, this is for simple ring servers, if this
   
   ;; doesn't work for you just run your own server :) (see lein-ring)
   
   ;; :ring-handler hello_world.server/handler
   
   ;; To be able to open files in your editor from the heads up display
   ;; you will need to put a script on your path.
   ;; that script will have to take a file path and a line number
   ;; ie. in  ~/bin/myfile-opener
   ;; #! /bin/sh
   ;; emacsclient -n +$2 $1
   ;;
   ;; :open-file-command "myfile-opener"
   
   ;; if you are using emacsclient you can just use
   ;; :open-file-command "emacsclient"
   
   ;; if you want to disable the REPL
   ;; :repl false
   
   ;; to configure a different figwheel logfile path
   ;; :server-logfile "tmp/logs/figwheel-logfile.log"
   }
  
  
  ;; setting up nREPL for Figwheel and ClojureScript dev
  ;; Please see:
  ;; https://github.com/bhauman/lein-figwheel/wiki/Using-the-Figwheel-REPL-within-NRepl
  
  
  :profiles
  {:dev {:dependencies
         [[binaryage/devtools "0.9.0"]
          [figwheel-sidecar "0.5.9"]
          [com.cemerick/piggieback "0.2.1"]]
         ;; need to add dev source path here to get user.clj loaded
         :source-paths ["src" "dev"]
         ;; for CIDER
         ;; :plugins [[cider/cider-nrepl "0.12.0"]]
         :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}}})
