// Compiled by ClojureScript 1.10.520 {}
goog.provide('day8.re_frame_10x.utils.localstorage');
goog.require('cljs.core');
goog.require('goog.storage.Storage');
goog.require('goog.storage.mechanism.HTML5LocalStorage');
goog.require('cljs.reader');
goog.require('clojure.string');
day8.re_frame_10x.utils.localstorage.storage = (new goog.storage.Storage((new goog.storage.mechanism.HTML5LocalStorage())));
day8.re_frame_10x.utils.localstorage.safe_prefix = "day8.re-frame-10x.";
day8.re_frame_10x.utils.localstorage.safe_key = (function day8$re_frame_10x$utils$localstorage$safe_key(key){

return [day8.re_frame_10x.utils.localstorage.safe_prefix,cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
});
/**
 * Gets a re-frame-10x value from local storage.
 */
day8.re_frame_10x.utils.localstorage.get = (function day8$re_frame_10x$utils$localstorage$get(var_args){
var G__31555 = arguments.length;
switch (G__31555) {
case 1:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$1 = (function (key){
return day8.re_frame_10x.utils.localstorage.get.call(null,key,null);
});

day8.re_frame_10x.utils.localstorage.get.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var value = day8.re_frame_10x.utils.localstorage.storage.get(day8.re_frame_10x.utils.localstorage.safe_key.call(null,key));
if((void 0 === value)){
return not_found;
} else {
return cljs.reader.read_string.call(null,value);
}
});

day8.re_frame_10x.utils.localstorage.get.cljs$lang$maxFixedArity = 2;

/**
 * Saves a re-frame-10x value to local storage.
 */
day8.re_frame_10x.utils.localstorage.save_BANG_ = (function day8$re_frame_10x$utils$localstorage$save_BANG_(key,value){
return day8.re_frame_10x.utils.localstorage.storage.set(day8.re_frame_10x.utils.localstorage.safe_key.call(null,key),cljs.core.pr_str.call(null,value));
});
/**
 * Deletes all re-frame-10x config keys
 */
day8.re_frame_10x.utils.localstorage.delete_all_keys_BANG_ = (function day8$re_frame_10x$utils$localstorage$delete_all_keys_BANG_(){
var seq__31557 = cljs.core.seq.call(null,Object.keys(localStorage));
var chunk__31558 = null;
var count__31559 = (0);
var i__31560 = (0);
while(true){
if((i__31560 < count__31559)){
var k = cljs.core._nth.call(null,chunk__31558,i__31560);
if(clojure.string.starts_with_QMARK_.call(null,k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__31561 = seq__31557;
var G__31562 = chunk__31558;
var G__31563 = count__31559;
var G__31564 = (i__31560 + (1));
seq__31557 = G__31561;
chunk__31558 = G__31562;
count__31559 = G__31563;
i__31560 = G__31564;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__31557);
if(temp__5720__auto__){
var seq__31557__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31557__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__31557__$1);
var G__31565 = cljs.core.chunk_rest.call(null,seq__31557__$1);
var G__31566 = c__4550__auto__;
var G__31567 = cljs.core.count.call(null,c__4550__auto__);
var G__31568 = (0);
seq__31557 = G__31565;
chunk__31558 = G__31566;
count__31559 = G__31567;
i__31560 = G__31568;
continue;
} else {
var k = cljs.core.first.call(null,seq__31557__$1);
if(clojure.string.starts_with_QMARK_.call(null,k,day8.re_frame_10x.utils.localstorage.safe_prefix)){
day8.re_frame_10x.utils.localstorage.storage.remove(k);
} else {
}


var G__31569 = cljs.core.next.call(null,seq__31557__$1);
var G__31570 = null;
var G__31571 = (0);
var G__31572 = (0);
seq__31557 = G__31569;
chunk__31558 = G__31570;
count__31559 = G__31571;
i__31560 = G__31572;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=localstorage.js.map?rel=1571863656442
