// Compiled by ClojureScript 1.10.520 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.18";
figwheel.client.js_stringify = (((((typeof JSON !== 'undefined')) && ((!((JSON.stringify == null))))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
}catch (e36726){if((e36726 instanceof Error)){
var e = e36726;
return "Error: Unable to stringify";
} else {
throw e36726;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__36729 = arguments.length;
switch (G__36729) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__36727_SHARP_){
if(typeof p1__36727_SHARP_ === 'string'){
return p1__36727_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__36727_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___36732 = arguments.length;
var i__4731__auto___36733 = (0);
while(true){
if((i__4731__auto___36733 < len__4730__auto___36732)){
args__4736__auto__.push((arguments[i__4731__auto___36733]));

var G__36734 = (i__4731__auto___36733 + (1));
i__4731__auto___36733 = G__36734;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq36731){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36731));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___36736 = arguments.length;
var i__4731__auto___36737 = (0);
while(true){
if((i__4731__auto___36737 < len__4730__auto___36736)){
args__4736__auto__.push((arguments[i__4731__auto___36737]));

var G__36738 = (i__4731__auto___36737 + (1));
i__4731__auto___36737 = G__36738;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq36735){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36735));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),"Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",(cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF")].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__36739){
var map__36740 = p__36739;
var map__36740__$1 = (((((!((map__36740 == null))))?(((((map__36740.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36740.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36740):map__36740);
var message = cljs.core.get.call(null,map__36740__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__36740__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__4131__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__4120__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__4120__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__4120__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__33696__auto___36819 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___36819,ch){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___36819,ch){
return (function (state_36791){
var state_val_36792 = (state_36791[(1)]);
if((state_val_36792 === (7))){
var inst_36787 = (state_36791[(2)]);
var state_36791__$1 = state_36791;
var statearr_36793_36820 = state_36791__$1;
(statearr_36793_36820[(2)] = inst_36787);

(statearr_36793_36820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (1))){
var state_36791__$1 = state_36791;
var statearr_36794_36821 = state_36791__$1;
(statearr_36794_36821[(2)] = null);

(statearr_36794_36821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (4))){
var inst_36744 = (state_36791[(7)]);
var inst_36744__$1 = (state_36791[(2)]);
var state_36791__$1 = (function (){var statearr_36795 = state_36791;
(statearr_36795[(7)] = inst_36744__$1);

return statearr_36795;
})();
if(cljs.core.truth_(inst_36744__$1)){
var statearr_36796_36822 = state_36791__$1;
(statearr_36796_36822[(1)] = (5));

} else {
var statearr_36797_36823 = state_36791__$1;
(statearr_36797_36823[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (15))){
var inst_36751 = (state_36791[(8)]);
var inst_36766 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_36751);
var inst_36767 = cljs.core.first.call(null,inst_36766);
var inst_36768 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_36767);
var inst_36769 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36768)].join('');
var inst_36770 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_36769);
var state_36791__$1 = state_36791;
var statearr_36798_36824 = state_36791__$1;
(statearr_36798_36824[(2)] = inst_36770);

(statearr_36798_36824[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (13))){
var inst_36775 = (state_36791[(2)]);
var state_36791__$1 = state_36791;
var statearr_36799_36825 = state_36791__$1;
(statearr_36799_36825[(2)] = inst_36775);

(statearr_36799_36825[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (6))){
var state_36791__$1 = state_36791;
var statearr_36800_36826 = state_36791__$1;
(statearr_36800_36826[(2)] = null);

(statearr_36800_36826[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (17))){
var inst_36773 = (state_36791[(2)]);
var state_36791__$1 = state_36791;
var statearr_36801_36827 = state_36791__$1;
(statearr_36801_36827[(2)] = inst_36773);

(statearr_36801_36827[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (3))){
var inst_36789 = (state_36791[(2)]);
var state_36791__$1 = state_36791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36791__$1,inst_36789);
} else {
if((state_val_36792 === (12))){
var inst_36750 = (state_36791[(9)]);
var inst_36764 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_36750,opts);
var state_36791__$1 = state_36791;
if(inst_36764){
var statearr_36802_36828 = state_36791__$1;
(statearr_36802_36828[(1)] = (15));

} else {
var statearr_36803_36829 = state_36791__$1;
(statearr_36803_36829[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (2))){
var state_36791__$1 = state_36791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36791__$1,(4),ch);
} else {
if((state_val_36792 === (11))){
var inst_36751 = (state_36791[(8)]);
var inst_36756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36757 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_36751);
var inst_36758 = cljs.core.async.timeout.call(null,(1000));
var inst_36759 = [inst_36757,inst_36758];
var inst_36760 = (new cljs.core.PersistentVector(null,2,(5),inst_36756,inst_36759,null));
var state_36791__$1 = state_36791;
return cljs.core.async.ioc_alts_BANG_.call(null,state_36791__$1,(14),inst_36760);
} else {
if((state_val_36792 === (9))){
var inst_36751 = (state_36791[(8)]);
var inst_36777 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_36778 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_36751);
var inst_36779 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_36778);
var inst_36780 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36779)].join('');
var inst_36781 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_36780);
var state_36791__$1 = (function (){var statearr_36804 = state_36791;
(statearr_36804[(10)] = inst_36777);

return statearr_36804;
})();
var statearr_36805_36830 = state_36791__$1;
(statearr_36805_36830[(2)] = inst_36781);

(statearr_36805_36830[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (5))){
var inst_36744 = (state_36791[(7)]);
var inst_36746 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_36747 = (new cljs.core.PersistentArrayMap(null,2,inst_36746,null));
var inst_36748 = (new cljs.core.PersistentHashSet(null,inst_36747,null));
var inst_36749 = figwheel.client.focus_msgs.call(null,inst_36748,inst_36744);
var inst_36750 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_36749);
var inst_36751 = cljs.core.first.call(null,inst_36749);
var inst_36752 = figwheel.client.autoload_QMARK_.call(null);
var state_36791__$1 = (function (){var statearr_36806 = state_36791;
(statearr_36806[(8)] = inst_36751);

(statearr_36806[(9)] = inst_36750);

return statearr_36806;
})();
if(cljs.core.truth_(inst_36752)){
var statearr_36807_36831 = state_36791__$1;
(statearr_36807_36831[(1)] = (8));

} else {
var statearr_36808_36832 = state_36791__$1;
(statearr_36808_36832[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (14))){
var inst_36762 = (state_36791[(2)]);
var state_36791__$1 = state_36791;
var statearr_36809_36833 = state_36791__$1;
(statearr_36809_36833[(2)] = inst_36762);

(statearr_36809_36833[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (16))){
var state_36791__$1 = state_36791;
var statearr_36810_36834 = state_36791__$1;
(statearr_36810_36834[(2)] = null);

(statearr_36810_36834[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (10))){
var inst_36783 = (state_36791[(2)]);
var state_36791__$1 = (function (){var statearr_36811 = state_36791;
(statearr_36811[(11)] = inst_36783);

return statearr_36811;
})();
var statearr_36812_36835 = state_36791__$1;
(statearr_36812_36835[(2)] = null);

(statearr_36812_36835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36792 === (8))){
var inst_36750 = (state_36791[(9)]);
var inst_36754 = figwheel.client.reload_file_state_QMARK_.call(null,inst_36750,opts);
var state_36791__$1 = state_36791;
if(cljs.core.truth_(inst_36754)){
var statearr_36813_36836 = state_36791__$1;
(statearr_36813_36836[(1)] = (11));

} else {
var statearr_36814_36837 = state_36791__$1;
(statearr_36814_36837[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto___36819,ch))
;
return ((function (switch__33601__auto__,c__33696__auto___36819,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__33602__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__33602__auto____0 = (function (){
var statearr_36815 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36815[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__33602__auto__);

(statearr_36815[(1)] = (1));

return statearr_36815;
});
var figwheel$client$file_reloader_plugin_$_state_machine__33602__auto____1 = (function (state_36791){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_36791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e36816){if((e36816 instanceof Object)){
var ex__33605__auto__ = e36816;
var statearr_36817_36838 = state_36791;
(statearr_36817_36838[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36791);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36816;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36839 = state_36791;
state_36791 = G__36839;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__33602__auto__ = function(state_36791){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__33602__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__33602__auto____1.call(this,state_36791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__33602__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__33602__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___36819,ch))
})();
var state__33698__auto__ = (function (){var statearr_36818 = f__33697__auto__.call(null);
(statearr_36818[(6)] = c__33696__auto___36819);

return statearr_36818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___36819,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__36840_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__36840_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(figwheel.client.utils.node_env_QMARK_.call(null)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_36846 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_36846){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__36842 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__36843 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__36844 = true;
var _STAR_print_fn_STAR__temp_val__36845 = ((function (_STAR_print_newline_STAR__orig_val__36842,_STAR_print_fn_STAR__orig_val__36843,_STAR_print_newline_STAR__temp_val__36844,sb,base_path_36846){
return (function (x){
return sb.append(x);
});})(_STAR_print_newline_STAR__orig_val__36842,_STAR_print_fn_STAR__orig_val__36843,_STAR_print_newline_STAR__temp_val__36844,sb,base_path_36846))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__36844;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__36845;

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
var result_value__$1 = (((!(typeof result_value === 'string')))?cljs.core.pr_str.call(null,result_value):result_value);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"out","out",-910545517),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value__$1], null));
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__36843;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__36842;
}}catch (e36841){if((e36841 instanceof Error)){
var e = e36841;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_36846], null));
} else {
var e = e36841;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_36846))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__36847){
var map__36848 = p__36847;
var map__36848__$1 = (((((!((map__36848 == null))))?(((((map__36848.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36848.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36848):map__36848);
var opts = map__36848__$1;
var build_id = cljs.core.get.call(null,map__36848__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__36848,map__36848__$1,opts,build_id){
return (function (p__36850){
var vec__36851 = p__36850;
var seq__36852 = cljs.core.seq.call(null,vec__36851);
var first__36853 = cljs.core.first.call(null,seq__36852);
var seq__36852__$1 = cljs.core.next.call(null,seq__36852);
var map__36854 = first__36853;
var map__36854__$1 = (((((!((map__36854 == null))))?(((((map__36854.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36854.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36854):map__36854);
var msg = map__36854__$1;
var msg_name = cljs.core.get.call(null,map__36854__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__36852__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__36851,seq__36852,first__36853,seq__36852__$1,map__36854,map__36854__$1,msg,msg_name,_,map__36848,map__36848__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__36851,seq__36852,first__36853,seq__36852__$1,map__36854,map__36854__$1,msg,msg_name,_,map__36848,map__36848__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__36848,map__36848__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__36856){
var vec__36857 = p__36856;
var seq__36858 = cljs.core.seq.call(null,vec__36857);
var first__36859 = cljs.core.first.call(null,seq__36858);
var seq__36858__$1 = cljs.core.next.call(null,seq__36858);
var map__36860 = first__36859;
var map__36860__$1 = (((((!((map__36860 == null))))?(((((map__36860.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36860.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36860):map__36860);
var msg = map__36860__$1;
var msg_name = cljs.core.get.call(null,map__36860__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__36858__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__36862){
var map__36863 = p__36862;
var map__36863__$1 = (((((!((map__36863 == null))))?(((((map__36863.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36863.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36863):map__36863);
var on_compile_warning = cljs.core.get.call(null,map__36863__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__36863__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__36863,map__36863__$1,on_compile_warning,on_compile_fail){
return (function (p__36865){
var vec__36866 = p__36865;
var seq__36867 = cljs.core.seq.call(null,vec__36866);
var first__36868 = cljs.core.first.call(null,seq__36867);
var seq__36867__$1 = cljs.core.next.call(null,seq__36867);
var map__36869 = first__36868;
var map__36869__$1 = (((((!((map__36869 == null))))?(((((map__36869.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36869.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36869):map__36869);
var msg = map__36869__$1;
var msg_name = cljs.core.get.call(null,map__36869__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__36867__$1;
var pred__36871 = cljs.core._EQ_;
var expr__36872 = msg_name;
if(cljs.core.truth_(pred__36871.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__36872))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__36871.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__36872))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__36863,map__36863__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__33696__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto__,msg_hist,msg_names,msg){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto__,msg_hist,msg_names,msg){
return (function (state_36961){
var state_val_36962 = (state_36961[(1)]);
if((state_val_36962 === (7))){
var inst_36881 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
if(cljs.core.truth_(inst_36881)){
var statearr_36963_37010 = state_36961__$1;
(statearr_36963_37010[(1)] = (8));

} else {
var statearr_36964_37011 = state_36961__$1;
(statearr_36964_37011[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (20))){
var inst_36955 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
var statearr_36965_37012 = state_36961__$1;
(statearr_36965_37012[(2)] = inst_36955);

(statearr_36965_37012[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (27))){
var inst_36951 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
var statearr_36966_37013 = state_36961__$1;
(statearr_36966_37013[(2)] = inst_36951);

(statearr_36966_37013[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (1))){
var inst_36874 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_36961__$1 = state_36961;
if(cljs.core.truth_(inst_36874)){
var statearr_36967_37014 = state_36961__$1;
(statearr_36967_37014[(1)] = (2));

} else {
var statearr_36968_37015 = state_36961__$1;
(statearr_36968_37015[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (24))){
var inst_36953 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
var statearr_36969_37016 = state_36961__$1;
(statearr_36969_37016[(2)] = inst_36953);

(statearr_36969_37016[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (4))){
var inst_36959 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36961__$1,inst_36959);
} else {
if((state_val_36962 === (15))){
var inst_36957 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
var statearr_36970_37017 = state_36961__$1;
(statearr_36970_37017[(2)] = inst_36957);

(statearr_36970_37017[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (21))){
var inst_36910 = (state_36961[(2)]);
var inst_36911 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_36912 = figwheel.client.auto_jump_to_error.call(null,opts,inst_36911);
var state_36961__$1 = (function (){var statearr_36971 = state_36961;
(statearr_36971[(7)] = inst_36910);

return statearr_36971;
})();
var statearr_36972_37018 = state_36961__$1;
(statearr_36972_37018[(2)] = inst_36912);

(statearr_36972_37018[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (31))){
var inst_36940 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_36961__$1 = state_36961;
if(inst_36940){
var statearr_36973_37019 = state_36961__$1;
(statearr_36973_37019[(1)] = (34));

} else {
var statearr_36974_37020 = state_36961__$1;
(statearr_36974_37020[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (32))){
var inst_36949 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
var statearr_36975_37021 = state_36961__$1;
(statearr_36975_37021[(2)] = inst_36949);

(statearr_36975_37021[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (33))){
var inst_36936 = (state_36961[(2)]);
var inst_36937 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_36938 = figwheel.client.auto_jump_to_error.call(null,opts,inst_36937);
var state_36961__$1 = (function (){var statearr_36976 = state_36961;
(statearr_36976[(8)] = inst_36936);

return statearr_36976;
})();
var statearr_36977_37022 = state_36961__$1;
(statearr_36977_37022[(2)] = inst_36938);

(statearr_36977_37022[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (13))){
var inst_36895 = figwheel.client.heads_up.clear.call(null);
var state_36961__$1 = state_36961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36961__$1,(16),inst_36895);
} else {
if((state_val_36962 === (22))){
var inst_36916 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_36917 = figwheel.client.heads_up.append_warning_message.call(null,inst_36916);
var state_36961__$1 = state_36961;
var statearr_36978_37023 = state_36961__$1;
(statearr_36978_37023[(2)] = inst_36917);

(statearr_36978_37023[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (36))){
var inst_36947 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
var statearr_36979_37024 = state_36961__$1;
(statearr_36979_37024[(2)] = inst_36947);

(statearr_36979_37024[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (29))){
var inst_36927 = (state_36961[(2)]);
var inst_36928 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_36929 = figwheel.client.auto_jump_to_error.call(null,opts,inst_36928);
var state_36961__$1 = (function (){var statearr_36980 = state_36961;
(statearr_36980[(9)] = inst_36927);

return statearr_36980;
})();
var statearr_36981_37025 = state_36961__$1;
(statearr_36981_37025[(2)] = inst_36929);

(statearr_36981_37025[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (6))){
var inst_36876 = (state_36961[(10)]);
var state_36961__$1 = state_36961;
var statearr_36982_37026 = state_36961__$1;
(statearr_36982_37026[(2)] = inst_36876);

(statearr_36982_37026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (28))){
var inst_36923 = (state_36961[(2)]);
var inst_36924 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_36925 = figwheel.client.heads_up.display_warning.call(null,inst_36924);
var state_36961__$1 = (function (){var statearr_36983 = state_36961;
(statearr_36983[(11)] = inst_36923);

return statearr_36983;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36961__$1,(29),inst_36925);
} else {
if((state_val_36962 === (25))){
var inst_36921 = figwheel.client.heads_up.clear.call(null);
var state_36961__$1 = state_36961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36961__$1,(28),inst_36921);
} else {
if((state_val_36962 === (34))){
var inst_36942 = figwheel.client.heads_up.flash_loaded.call(null);
var state_36961__$1 = state_36961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36961__$1,(37),inst_36942);
} else {
if((state_val_36962 === (17))){
var inst_36901 = (state_36961[(2)]);
var inst_36902 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_36903 = figwheel.client.auto_jump_to_error.call(null,opts,inst_36902);
var state_36961__$1 = (function (){var statearr_36984 = state_36961;
(statearr_36984[(12)] = inst_36901);

return statearr_36984;
})();
var statearr_36985_37027 = state_36961__$1;
(statearr_36985_37027[(2)] = inst_36903);

(statearr_36985_37027[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (3))){
var inst_36893 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_36961__$1 = state_36961;
if(inst_36893){
var statearr_36986_37028 = state_36961__$1;
(statearr_36986_37028[(1)] = (13));

} else {
var statearr_36987_37029 = state_36961__$1;
(statearr_36987_37029[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (12))){
var inst_36889 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
var statearr_36988_37030 = state_36961__$1;
(statearr_36988_37030[(2)] = inst_36889);

(statearr_36988_37030[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (2))){
var inst_36876 = (state_36961[(10)]);
var inst_36876__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_36961__$1 = (function (){var statearr_36989 = state_36961;
(statearr_36989[(10)] = inst_36876__$1);

return statearr_36989;
})();
if(cljs.core.truth_(inst_36876__$1)){
var statearr_36990_37031 = state_36961__$1;
(statearr_36990_37031[(1)] = (5));

} else {
var statearr_36991_37032 = state_36961__$1;
(statearr_36991_37032[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (23))){
var inst_36919 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_36961__$1 = state_36961;
if(inst_36919){
var statearr_36992_37033 = state_36961__$1;
(statearr_36992_37033[(1)] = (25));

} else {
var statearr_36993_37034 = state_36961__$1;
(statearr_36993_37034[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (35))){
var state_36961__$1 = state_36961;
var statearr_36994_37035 = state_36961__$1;
(statearr_36994_37035[(2)] = null);

(statearr_36994_37035[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (19))){
var inst_36914 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_36961__$1 = state_36961;
if(inst_36914){
var statearr_36995_37036 = state_36961__$1;
(statearr_36995_37036[(1)] = (22));

} else {
var statearr_36996_37037 = state_36961__$1;
(statearr_36996_37037[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (11))){
var inst_36885 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
var statearr_36997_37038 = state_36961__$1;
(statearr_36997_37038[(2)] = inst_36885);

(statearr_36997_37038[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (9))){
var inst_36887 = figwheel.client.heads_up.clear.call(null);
var state_36961__$1 = state_36961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36961__$1,(12),inst_36887);
} else {
if((state_val_36962 === (5))){
var inst_36878 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_36961__$1 = state_36961;
var statearr_36998_37039 = state_36961__$1;
(statearr_36998_37039[(2)] = inst_36878);

(statearr_36998_37039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (14))){
var inst_36905 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_36961__$1 = state_36961;
if(inst_36905){
var statearr_36999_37040 = state_36961__$1;
(statearr_36999_37040[(1)] = (18));

} else {
var statearr_37000_37041 = state_36961__$1;
(statearr_37000_37041[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (26))){
var inst_36931 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_36961__$1 = state_36961;
if(inst_36931){
var statearr_37001_37042 = state_36961__$1;
(statearr_37001_37042[(1)] = (30));

} else {
var statearr_37002_37043 = state_36961__$1;
(statearr_37002_37043[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (16))){
var inst_36897 = (state_36961[(2)]);
var inst_36898 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_36899 = figwheel.client.heads_up.display_exception.call(null,inst_36898);
var state_36961__$1 = (function (){var statearr_37003 = state_36961;
(statearr_37003[(13)] = inst_36897);

return statearr_37003;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36961__$1,(17),inst_36899);
} else {
if((state_val_36962 === (30))){
var inst_36933 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_36934 = figwheel.client.heads_up.display_warning.call(null,inst_36933);
var state_36961__$1 = state_36961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36961__$1,(33),inst_36934);
} else {
if((state_val_36962 === (10))){
var inst_36891 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
var statearr_37004_37044 = state_36961__$1;
(statearr_37004_37044[(2)] = inst_36891);

(statearr_37004_37044[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (18))){
var inst_36907 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_36908 = figwheel.client.heads_up.display_exception.call(null,inst_36907);
var state_36961__$1 = state_36961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36961__$1,(21),inst_36908);
} else {
if((state_val_36962 === (37))){
var inst_36944 = (state_36961[(2)]);
var state_36961__$1 = state_36961;
var statearr_37005_37045 = state_36961__$1;
(statearr_37005_37045[(2)] = inst_36944);

(statearr_37005_37045[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36962 === (8))){
var inst_36883 = figwheel.client.heads_up.flash_loaded.call(null);
var state_36961__$1 = state_36961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36961__$1,(11),inst_36883);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33696__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__33601__auto__,c__33696__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto____0 = (function (){
var statearr_37006 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37006[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto__);

(statearr_37006[(1)] = (1));

return statearr_37006;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto____1 = (function (state_36961){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_36961);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e37007){if((e37007 instanceof Object)){
var ex__33605__auto__ = e37007;
var statearr_37008_37046 = state_36961;
(statearr_37008_37046[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36961);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37007;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37047 = state_36961;
state_36961 = G__37047;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto__ = function(state_36961){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto____1.call(this,state_36961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto__,msg_hist,msg_names,msg))
})();
var state__33698__auto__ = (function (){var statearr_37009 = f__33697__auto__.call(null);
(statearr_37009[(6)] = c__33696__auto__);

return statearr_37009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto__,msg_hist,msg_names,msg))
);

return c__33696__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__33696__auto___37076 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto___37076,ch){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto___37076,ch){
return (function (state_37062){
var state_val_37063 = (state_37062[(1)]);
if((state_val_37063 === (1))){
var state_37062__$1 = state_37062;
var statearr_37064_37077 = state_37062__$1;
(statearr_37064_37077[(2)] = null);

(statearr_37064_37077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37063 === (2))){
var state_37062__$1 = state_37062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37062__$1,(4),ch);
} else {
if((state_val_37063 === (3))){
var inst_37060 = (state_37062[(2)]);
var state_37062__$1 = state_37062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37062__$1,inst_37060);
} else {
if((state_val_37063 === (4))){
var inst_37050 = (state_37062[(7)]);
var inst_37050__$1 = (state_37062[(2)]);
var state_37062__$1 = (function (){var statearr_37065 = state_37062;
(statearr_37065[(7)] = inst_37050__$1);

return statearr_37065;
})();
if(cljs.core.truth_(inst_37050__$1)){
var statearr_37066_37078 = state_37062__$1;
(statearr_37066_37078[(1)] = (5));

} else {
var statearr_37067_37079 = state_37062__$1;
(statearr_37067_37079[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37063 === (5))){
var inst_37050 = (state_37062[(7)]);
var inst_37052 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_37050);
var state_37062__$1 = state_37062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37062__$1,(8),inst_37052);
} else {
if((state_val_37063 === (6))){
var state_37062__$1 = state_37062;
var statearr_37068_37080 = state_37062__$1;
(statearr_37068_37080[(2)] = null);

(statearr_37068_37080[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37063 === (7))){
var inst_37058 = (state_37062[(2)]);
var state_37062__$1 = state_37062;
var statearr_37069_37081 = state_37062__$1;
(statearr_37069_37081[(2)] = inst_37058);

(statearr_37069_37081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37063 === (8))){
var inst_37054 = (state_37062[(2)]);
var state_37062__$1 = (function (){var statearr_37070 = state_37062;
(statearr_37070[(8)] = inst_37054);

return statearr_37070;
})();
var statearr_37071_37082 = state_37062__$1;
(statearr_37071_37082[(2)] = null);

(statearr_37071_37082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__33696__auto___37076,ch))
;
return ((function (switch__33601__auto__,c__33696__auto___37076,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__33602__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__33602__auto____0 = (function (){
var statearr_37072 = [null,null,null,null,null,null,null,null,null];
(statearr_37072[(0)] = figwheel$client$heads_up_plugin_$_state_machine__33602__auto__);

(statearr_37072[(1)] = (1));

return statearr_37072;
});
var figwheel$client$heads_up_plugin_$_state_machine__33602__auto____1 = (function (state_37062){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_37062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e37073){if((e37073 instanceof Object)){
var ex__33605__auto__ = e37073;
var statearr_37074_37083 = state_37062;
(statearr_37074_37083[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37062);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37073;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37084 = state_37062;
state_37062 = G__37084;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__33602__auto__ = function(state_37062){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__33602__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__33602__auto____1.call(this,state_37062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__33602__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__33602__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto___37076,ch))
})();
var state__33698__auto__ = (function (){var statearr_37075 = f__33697__auto__.call(null);
(statearr_37075[(6)] = c__33696__auto___37076);

return statearr_37075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto___37076,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__33696__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto__){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto__){
return (function (state_37090){
var state_val_37091 = (state_37090[(1)]);
if((state_val_37091 === (1))){
var inst_37085 = cljs.core.async.timeout.call(null,(3000));
var state_37090__$1 = state_37090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37090__$1,(2),inst_37085);
} else {
if((state_val_37091 === (2))){
var inst_37087 = (state_37090[(2)]);
var inst_37088 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_37090__$1 = (function (){var statearr_37092 = state_37090;
(statearr_37092[(7)] = inst_37087);

return statearr_37092;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37090__$1,inst_37088);
} else {
return null;
}
}
});})(c__33696__auto__))
;
return ((function (switch__33601__auto__,c__33696__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__33602__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__33602__auto____0 = (function (){
var statearr_37093 = [null,null,null,null,null,null,null,null];
(statearr_37093[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__33602__auto__);

(statearr_37093[(1)] = (1));

return statearr_37093;
});
var figwheel$client$enforce_project_plugin_$_state_machine__33602__auto____1 = (function (state_37090){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_37090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e37094){if((e37094 instanceof Object)){
var ex__33605__auto__ = e37094;
var statearr_37095_37097 = state_37090;
(statearr_37095_37097[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37090);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37094;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37098 = state_37090;
state_37090 = G__37098;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__33602__auto__ = function(state_37090){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__33602__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__33602__auto____1.call(this,state_37090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__33602__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__33602__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto__))
})();
var state__33698__auto__ = (function (){var statearr_37096 = f__33697__auto__.call(null);
(statearr_37096[(6)] = c__33696__auto__);

return statearr_37096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto__))
);

return c__33696__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5720__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5720__auto__)){
var figwheel_version = temp__5720__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__33696__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33696__auto__,figwheel_version,temp__5720__auto__){
return (function (){
var f__33697__auto__ = (function (){var switch__33601__auto__ = ((function (c__33696__auto__,figwheel_version,temp__5720__auto__){
return (function (state_37105){
var state_val_37106 = (state_37105[(1)]);
if((state_val_37106 === (1))){
var inst_37099 = cljs.core.async.timeout.call(null,(2000));
var state_37105__$1 = state_37105;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37105__$1,(2),inst_37099);
} else {
if((state_val_37106 === (2))){
var inst_37101 = (state_37105[(2)]);
var inst_37102 = ["Figwheel Client Version <strong>",figwheel.client._figwheel_version_,"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_37103 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_37102);
var state_37105__$1 = (function (){var statearr_37107 = state_37105;
(statearr_37107[(7)] = inst_37101);

return statearr_37107;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37105__$1,inst_37103);
} else {
return null;
}
}
});})(c__33696__auto__,figwheel_version,temp__5720__auto__))
;
return ((function (switch__33601__auto__,c__33696__auto__,figwheel_version,temp__5720__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto____0 = (function (){
var statearr_37108 = [null,null,null,null,null,null,null,null];
(statearr_37108[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto__);

(statearr_37108[(1)] = (1));

return statearr_37108;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto____1 = (function (state_37105){
while(true){
var ret_value__33603__auto__ = (function (){try{while(true){
var result__33604__auto__ = switch__33601__auto__.call(null,state_37105);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33604__auto__;
}
break;
}
}catch (e37109){if((e37109 instanceof Object)){
var ex__33605__auto__ = e37109;
var statearr_37110_37112 = state_37105;
(statearr_37110_37112[(5)] = ex__33605__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37105);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37109;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33603__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37113 = state_37105;
state_37105 = G__37113;
continue;
} else {
return ret_value__33603__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto__ = function(state_37105){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto____1.call(this,state_37105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__33602__auto__;
})()
;})(switch__33601__auto__,c__33696__auto__,figwheel_version,temp__5720__auto__))
})();
var state__33698__auto__ = (function (){var statearr_37111 = f__33697__auto__.call(null);
(statearr_37111[(6)] = c__33696__auto__);

return statearr_37111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33698__auto__);
});})(c__33696__auto__,figwheel_version,temp__5720__auto__))
);

return c__33696__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__37114){
var map__37115 = p__37114;
var map__37115__$1 = (((((!((map__37115 == null))))?(((((map__37115.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37115.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37115):map__37115);
var file = cljs.core.get.call(null,map__37115__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__37115__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__37115__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__37117 = "";
var G__37117__$1 = (cljs.core.truth_(file)?[G__37117,"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__37117);
var G__37117__$2 = (cljs.core.truth_(line)?[G__37117__$1," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__37117__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = line;
if(cljs.core.truth_(and__4120__auto__)){
return column;
} else {
return and__4120__auto__;
}
})())){
return [G__37117__$2,", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__37117__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__37118){
var map__37119 = p__37118;
var map__37119__$1 = (((((!((map__37119 == null))))?(((((map__37119.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37119.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37119):map__37119);
var ed = map__37119__$1;
var exception_data = cljs.core.get.call(null,map__37119__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__37119__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
var message_37122 = (function (){var G__37121 = cljs.core.apply.call(null,cljs.core.str,"Figwheel: Compile Exception ",figwheel.client.format_messages.call(null,exception_data));
if(cljs.core.truth_(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(exception_data))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37121)," Error on ",figwheel.client.file_line_column.call(null,exception_data)].join('');
} else {
return G__37121;
}
})();
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),message_37122);

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__37123){
var map__37124 = p__37123;
var map__37124__$1 = (((((!((map__37124 == null))))?(((((map__37124.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37124.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37124):map__37124);
var w = map__37124__$1;
var message = cljs.core.get.call(null,map__37124__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",figwheel.client.file_line_column.call(null,message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.config_defaults !== 'undefined')){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/compiled/out/figwheel/client.cljs",33,1,362,362,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/compiled/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(figwheel.client.utils.html_env_QMARK_.call(null)){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = (((!(figwheel.client.utils.html_env_QMARK_.call(null))))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__4120__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__4120__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__37126 = cljs.core.seq.call(null,plugins);
var chunk__37127 = null;
var count__37128 = (0);
var i__37129 = (0);
while(true){
if((i__37129 < count__37128)){
var vec__37136 = cljs.core._nth.call(null,chunk__37127,i__37129);
var k = cljs.core.nth.call(null,vec__37136,(0),null);
var plugin = cljs.core.nth.call(null,vec__37136,(1),null);
if(cljs.core.truth_(plugin)){
var pl_37142 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__37126,chunk__37127,count__37128,i__37129,pl_37142,vec__37136,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_37142.call(null,msg_hist);
});})(seq__37126,chunk__37127,count__37128,i__37129,pl_37142,vec__37136,k,plugin))
);
} else {
}


var G__37143 = seq__37126;
var G__37144 = chunk__37127;
var G__37145 = count__37128;
var G__37146 = (i__37129 + (1));
seq__37126 = G__37143;
chunk__37127 = G__37144;
count__37128 = G__37145;
i__37129 = G__37146;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__37126);
if(temp__5720__auto__){
var seq__37126__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37126__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__37126__$1);
var G__37147 = cljs.core.chunk_rest.call(null,seq__37126__$1);
var G__37148 = c__4550__auto__;
var G__37149 = cljs.core.count.call(null,c__4550__auto__);
var G__37150 = (0);
seq__37126 = G__37147;
chunk__37127 = G__37148;
count__37128 = G__37149;
i__37129 = G__37150;
continue;
} else {
var vec__37139 = cljs.core.first.call(null,seq__37126__$1);
var k = cljs.core.nth.call(null,vec__37139,(0),null);
var plugin = cljs.core.nth.call(null,vec__37139,(1),null);
if(cljs.core.truth_(plugin)){
var pl_37151 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__37126,chunk__37127,count__37128,i__37129,pl_37151,vec__37139,k,plugin,seq__37126__$1,temp__5720__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_37151.call(null,msg_hist);
});})(seq__37126,chunk__37127,count__37128,i__37129,pl_37151,vec__37139,k,plugin,seq__37126__$1,temp__5720__auto__))
);
} else {
}


var G__37152 = cljs.core.next.call(null,seq__37126__$1);
var G__37153 = null;
var G__37154 = (0);
var G__37155 = (0);
seq__37126 = G__37152;
chunk__37127 = G__37153;
count__37128 = G__37154;
i__37129 = G__37155;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__37157 = arguments.length;
switch (G__37157) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.__figwheel_start_once__ !== 'undefined')){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__37158_37163 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__37159_37164 = null;
var count__37160_37165 = (0);
var i__37161_37166 = (0);
while(true){
if((i__37161_37166 < count__37160_37165)){
var msg_37167 = cljs.core._nth.call(null,chunk__37159_37164,i__37161_37166);
figwheel.client.socket.handle_incoming_message.call(null,msg_37167);


var G__37168 = seq__37158_37163;
var G__37169 = chunk__37159_37164;
var G__37170 = count__37160_37165;
var G__37171 = (i__37161_37166 + (1));
seq__37158_37163 = G__37168;
chunk__37159_37164 = G__37169;
count__37160_37165 = G__37170;
i__37161_37166 = G__37171;
continue;
} else {
var temp__5720__auto___37172 = cljs.core.seq.call(null,seq__37158_37163);
if(temp__5720__auto___37172){
var seq__37158_37173__$1 = temp__5720__auto___37172;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37158_37173__$1)){
var c__4550__auto___37174 = cljs.core.chunk_first.call(null,seq__37158_37173__$1);
var G__37175 = cljs.core.chunk_rest.call(null,seq__37158_37173__$1);
var G__37176 = c__4550__auto___37174;
var G__37177 = cljs.core.count.call(null,c__4550__auto___37174);
var G__37178 = (0);
seq__37158_37163 = G__37175;
chunk__37159_37164 = G__37176;
count__37160_37165 = G__37177;
i__37161_37166 = G__37178;
continue;
} else {
var msg_37179 = cljs.core.first.call(null,seq__37158_37173__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_37179);


var G__37180 = cljs.core.next.call(null,seq__37158_37173__$1);
var G__37181 = null;
var G__37182 = (0);
var G__37183 = (0);
seq__37158_37163 = G__37180;
chunk__37159_37164 = G__37181;
count__37160_37165 = G__37182;
i__37161_37166 = G__37183;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4736__auto__ = [];
var len__4730__auto___37188 = arguments.length;
var i__4731__auto___37189 = (0);
while(true){
if((i__4731__auto___37189 < len__4730__auto___37188)){
args__4736__auto__.push((arguments[i__4731__auto___37189]));

var G__37190 = (i__4731__auto___37189 + (1));
i__4731__auto___37189 = G__37190;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__37185){
var map__37186 = p__37185;
var map__37186__$1 = (((((!((map__37186 == null))))?(((((map__37186.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37186.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37186):map__37186);
var opts = map__37186__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq37184){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37184));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e37191){if((e37191 instanceof Error)){
var e = e37191;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e37191;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__37192){
var map__37193 = p__37192;
var map__37193__$1 = (((((!((map__37193 == null))))?(((((map__37193.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37193.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37193):map__37193);
var msg_name = cljs.core.get.call(null,map__37193__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1571863660424
