(ns automat.viz
  (:require
    [automat.compiler.core :as compiler]
    [clojure.set :as set]
    [automat.core :as c]
    [automat.fsm :as a])
  (:import
    [automat.compiler.core
     ICompiledAutomaton]))

(defn- pprint-inputs
  "Turns contiguous ranges from a to b into 'a..b'"
  [s]
  (let [number? #(or (number? %) (char? %))
        non-numbers (remove number? s)
        s (a/input-ranges (filter number? s))]
    (->> s
      (map
        #(cond
           (and (vector? %) (not= (first %) (second %)))
           (str (first %) ".." (second %))

           (vector? %)
           (first %)

           :else
           %))
      (concat non-numbers)
      (interpose ",")
      (apply str))))

(defn fsm->dot
  [fsm options]
  (let [fsm (compiler/precompile
              (if (instance? ICompiledAutomaton fsm)
                (-> fsm meta :fsm)
                fsm))
        states (compiler/states fsm)
        accept? (:accept fsm)
        src+dst->inputs (fn [src dst]
                          (->> (get-in fsm [:state->input->state src])
                            (filter #(= dst (val %)))
                            (map key)))]
    ))

(defn view
  ([fsm ])
  ([fsm options]))


(defn save
  ([fsm filename])
  ([fsm filename options]))


