(ns tangrammer.base
  (:require
   [com.stuartsierra.component :as component]
   [clojure.tools.logging :as logging]))

(defrecord FSM [fsm-fun funs-fun]
  component/Lifecycle
  (start [this]
    (let [deps* (dissoc this :funs :fsm-fun)
          external-fsms (reduce (fn [c [k v]] (assoc c k (:fsm v))) {} deps*)
          external-funs (reduce (fn [c [k v]] (assoc c k (:funs v))) {} deps*)
          fsm (fsm-fun external-fsms)]
      {:fsm fsm :funs  (with-meta (funs-fun external-funs) {:fsm fsm})}))
  (stop [this]
    this
    ;;    (println "stopping" this (meta this))
    ))

(defn new-fsm [fsm funs]
  (FSM. fsm funs))
