(ns tangrammer.auto
  " alpha development version but currently being in used in production.
  The main purpose with roc.auto is to manage the logic of complex logic flows normally used in controller functions"
  (:require [automat.viz :as v]
            [automat.compiler.core :as compiler]
            [automat.core :as a ]
            [tangrammer.base :as b]
            [com.stuartsierra.component :as component]
            [com.stuartsierra.dependency :as dep]
            [clojure.set :as set]
            [clojure.walk :as w]
            [clojure.tools.logging :as logging])
  (:import
   [automat.compiler.core
    ICompiledAutomaton]))

;;; tree data utils

(defn to-vector [d]
  (w/postwalk (fn [x]
                (if (map? x)
                  (vec (sort (seq x)))
                  x)) d))
(defn println* [& args]
                                        ;(println args)
  )
(defn log [data   last-path current-path v ]
  (println* "----")
  (println* "data" (first data))
  (println* "last-path" last-path )
  (println* "last-path" last-path "...." "current-path" (reverse current-path) )
  (when (sequential? v)
    (println* "calling!" current-path)))

(defn echo [path]
  (vec (reverse path)))
(defn process [c last-path last-index data]
  (if-not (first data)
    [c last-path last-index]
    (let [[k-index v] (first data)
          current-path  (conj last-path k-index)]
      (log data  last-path current-path v )
      (println*  ">>>?? current-path"  current-path "last-index" last-index k-index)
      (if (sequential? v)
        (let [[c *last-path* *last-index*] (process c current-path k-index v)

              _ (println* "*last-path*"(echo  *last-path*) "*last-index*" *last-index*)
              _ (println* "*current-path*"(echo  current-path) k-index)
              ]
          (recur c  (conj *last-path* (dec *last-index*)) *last-index*   (next data)))
        (recur (assoc c [(echo current-path)  :as (apply + current-path)] v)
               last-path
               k-index
               (next data))))))

(defn start-p
  ([data]
   (start-p data '(0)))
  ([data last-path]
   (->> (to-vector data)
        (process {} last-path 0)
        first)))

(defn increment [data] (reduce (fn [c [[_ _ k] v]]
                                 (assoc c k v)) {}
                               (start-p data '(1))))


;;; end tree data utils

;; these funs are shortcuts to manage logic flows in which the event state are derivated by former one

;; we should agreee the internal/external schema passed/recieved 

(defn adv [automaton]
  (fn [m t] [m (a/advance automaton m t :end)]))

(defn- execute-fun
  "lets define the fun with one or two args
  m => is model
  x => is last automata result

  Normally, you don't need automata in your domain functions"
  [fun m x]
  (let [m (or (:value  m) m)]
    (try
      (fun m x)
      (catch Exception e
        (if (= (class e) clojure.lang.ArityException)
          (fun m)
          (do
            (logging/error :automata/execute-fun x m)
            (throw e)))))))

(defn iterator-adv [automata-adv automata-fun]
  (fn [[m x]]
    (if-not (:accepted? x)
      (let [fun (automata-fun (:state-index x))
            [t model] (let [res (execute-fun fun m x)]
                        (if (sequential? res)
                          res
                          [res]))
            model (-> x
                      (update-in [:value] merge  model)
                      (assoc-in  [:value :last-fun] (or (-> fun meta :name keyword)
                                                        (keyword (str "state-index-fun-at" (:state-index x)))))
                      (assoc-in  [:value :result] t))]
        (automata-adv model t))
      :end)))

(defn run [model automaton automata-fun]
  (let [automata-adv (adv automaton)]
    (->> (automata-adv model :init)
         (iterate (iterator-adv automata-adv automata-fun))
         (take-while (fn [m] (not= :end m))))))

(defn run* [model automaton automata-fun]
  (->> (run model automaton automata-fun)
       last last))

(defn exec [auto-name model automaton automata-fun]
  (let [res  (run* model automaton (increment automata-fun))]
    (logging/info auto-name  ((juxt :last-fun :result) (:value res)))
    res))

(defn compile* [fsm]
  (a/compile [:init fsm]))

(defn view [fsm]
  (v/view fsm))

(defn precompile* [fsm]
  (compiler/precompile
   (if (instance? ICompiledAutomaton fsm)
     (-> fsm meta :fsm)
     fsm)))

(defn set-indexes [automata map & [dec?]]
  (let [dict (->> (precompile* automata)
                  :state->input->state
                  vals
                  (into {}))]
    (reduce (fn [c [path fun]]
              (let [fun-id (if (keyword? path)
                             (path dict)
                             path)]
                (assoc c (if (and dec? (pos? fun-id))
                           
                           
                           (dec fun-id)
                           fun-id) fun))) {} map)))

(defn find-states-to-middleware [fsm]
  (let [p* (precompile* fsm)
        a-s (first (:accept p*))
        s-i-s (:state->input->state p*)]
    (reduce (fn [c [k v]]
  ;;            (println "!!>>>> " k v "")
              (if (not-empty
                   (filter
                    (fn [[kk vv]]
;;                      (println "!!** "k kk vv "=>" (= vv a-s))
                      (= vv a-s))v))
                (conj c k)
                c))
            #{}
            s-i-s)))

(defn find-target-paths  [fsm]
  (let [p* (precompile* fsm)
        a-s (first (:accept p*))
        s-i-s (:state->input->state p*)]
    (->> s-i-s
         (map (fn [[k v]]
                   (ffirst
                    (filter
                     (fn [[kk vv]]
                       (= vv a-s)) v))))
         (filter some?))))

(defn find-any-path-to-accepted-state [fsm]
  (first (find-target-paths fsm))
  )

(defn apply-middleware
  "wraps result into another... thinking in connecting with other FSM"
  [to funs connect]
   (let [to-middle (find-states-to-middleware (:fsm (meta funs)))]
     (reduce
      (fn [c i]
        (assoc c i (fn [m]
                     (let [res ((get c i) m)]
                       (if (keyword? res)
                         connect
                         (conj  [connect] (peek res)))))))
      (set/rename-keys funs {0 to})
      to-middle)))

(defn forward
  [to funs]
  (set/rename-keys funs {0 to})
  )

(defn connect [base-funs target-funs conn-kw] ;;  process-event-log-funs event-processed :event-processed
  (println "connect!!!" conn-kw)
  (let [p (find-any-path-to-accepted-state (-> target-funs meta :fsm))]
    (println "connecting from " conn-kw "to" p)
    (set/rename-keys base-funs {conn-kw p})))

(defn >f* [path & [out]]
  {path #(do
           (vector (or out :done) (merge % {path :done})))})

(defn associate [fsm-fun funs-fun]
  (b/new-fsm fsm-fun funs-fun))

(defn- fun-exec [s]
  (let [s-m (-> s meta :s-m)
        entrypoint  (or (last (dep/topo-sort (component/dependency-graph s-m  (keys s-m))))
                        (ffirst s) ;;this is necessary when we don't compose fsm :! 
                        )
        a  (entrypoint s) 
        fsm (:fsm a)
        funs (:funs a)
        ]
    ;;     (logging/warn (:value res))
    #(exec % %2 (compile* fsm) (set-indexes fsm funs))))

(defmulti bind (fn [e] (.getName (type e))))

(defmethod bind "tangrammer.base.FSM" [e]
  (component/start e))

(defmethod bind "clojure.lang.PersistentArrayMap" [m]
  (let [s-m  (-> m (component/map->SystemMap))
        s (component/start s-m)]
    (with-meta s {:s-m s-m})))


(defmulti to-fun (fn [e] (.getName (type e))))

(defmethod to-fun "tangrammer.base.FSM" [bound-fsm]
    (let [started-bound-fsm (bind bound-fsm)
          fsm (:fsm started-bound-fsm)
         funs (:funs started-bound-fsm)]
     #(exec % %2 (compile* fsm) (set-indexes fsm funs))))

(defmethod to-fun "clojure.lang.PersistentArrayMap" [m]
  (fun-exec (bind m)))

(defn save [fsm name]
   (v/save fsm (str "./doc/fsm/" name ".png")))


